#include "headers.h"

XStageManager::XStageManager()
{
	m_DirectDrawHandler = NULL;

	m_ViewX = 0;
	m_ViewY = 0;

	m_TankManager = new XList<XObject*>;
	m_ItemManager = new XList<XObject*>;
	m_EffectManager = new XList<XObject*>;
	m_BackEffectManager = new XList<XObject*>;

	m_Background = new XBuffer(1,1);
	m_Land = new XBuffer(1,1);
	m_LandView = new XBigOffScreen;

	m_ActiveTank = NULL;
	m_ScrollObject = NULL;
}

XStageManager::~XStageManager()
{
	delete(m_TankManager);
	delete(m_ItemManager);
	delete(m_EffectManager);
	delete(m_BackEffectManager);

	delete m_Background;
	delete m_Land;	
	delete m_LandView;
}

void XStageManager::Create(XDirectDrawHandler *DDH, char *landname, char *backgroundname)
{
	m_DirectDrawHandler = DDH;
	m_Background->LoadBitmap(backgroundname);
	m_Land->LoadBitmap(landname);
	m_LandView->Create(m_DirectDrawHandler,1280,960);
	m_LandView->LoadBitmap(landname);

	m_XScrollRatioX1024 = (m_Background->GetWidth()-DDH->GetWidth())*1024/(m_Land->GetWidth()-DDH->GetWidth());
	m_YScrollRatioX1024 = (m_Background->GetHeight()-DDH->GetHeight())*1024/(m_Land->GetHeight()-DDH->GetHeight());
}

int XStageManager::GetViewX()
{
	return m_ViewX;
}

int XStageManager::GetViewY()
{
	return m_ViewY;
}

XDirectDrawHandler *XStageManager::GetDirectDrawHandler()
{
	return m_DirectDrawHandler;
}

XBuffer *XStageManager::GetLand()
{
	return m_Land;
}

XBuffer *XStageManager::GetBackground()
{
	return m_Background;
}

XBigOffScreen *XStageManager::GetLandView()
{
	return m_LandView;
}

XList<XObject*> *XStageManager::GetTankManager()
{
	return m_TankManager;
}

XList<XObject*> *XStageManager::GetItemManager()
{
	return m_ItemManager;
}

XObject *XStageManager::GetActiveTank()
{
	return m_ActiveTank;
}

XObject *XStageManager::GetScrollObject()
{
	return m_ScrollObject;
}

void XStageManager::SetViewX(int x)
{
	int max = m_Land->GetWidth()-m_DirectDrawHandler->GetWidth();
	if(x < 0) x = 0;
	if(x > max)	x = max;
	m_ViewX = x;
}

void XStageManager::SetViewY(int y)
{
	int max = m_Land->GetHeight()-m_DirectDrawHandler->GetHeight();
	if(y < 0) y = 0;
	if(y > max)	y = max;
	m_ViewY = y;
}

void XStageManager::SetActiveTank(XObject *tank)
{
	m_ActiveTank = tank;
	((XTank*)m_ActiveTank)->SetActiveMode();
}

void XStageManager::SetScrollObject(XObject *object)
{
	m_ScrollObject = object;
}

void XStageManager::AddTank(XObject *object)
{
	m_TankManager->AddEnd(object);
}

void XStageManager::AddItem(XObject *object)
{
	m_ItemManager->AddEnd(object);
}

void XStageManager::AddEffect(XObject *object)
{
	m_EffectManager->AddEnd(object);
}

void XStageManager::AddBackEffect(XObject *object)
{
	m_BackEffectManager->AddEnd(object);
}

void XStageManager::Action()
{
	XList<XObject*>::XIterator *iterator;

	if(((XTank*)m_ActiveTank)->GetAction() == TANK_ACTION_REST)
	{
		m_TankManager->GoFirstElement(&iterator);
		while(m_TankManager->IsEnd(iterator) == FALSE)
		{
			if(iterator->m_Data == m_ActiveTank) break;
			m_TankManager->GoNext(&iterator);
		}
		m_TankManager->GoNext(&iterator);
		if(m_TankManager->IsEnd(iterator)) m_TankManager->GoFirstElement(&iterator);
		SetActiveTank(iterator->m_Data);
		m_ScrollObject = iterator->m_Data;
	}

	m_TankManager->GoFirstElement(&iterator);
	while(m_TankManager->IsEnd(iterator) == FALSE)
	{
		m_TankManager->GetData(iterator)->Action();
		m_TankManager->GoNext(&iterator);
	}

	m_ItemManager->GoFirstElement(&iterator);
	while(m_ItemManager->IsEnd(iterator) == FALSE)
	{
		m_ItemManager->GetData(iterator)->Action();
		m_ItemManager->GoNext(&iterator);
	}
}

void XStageManager::Draw(XDirectDrawHandler *DD)
{
	// ޹ ׸
	XBuffer *screen_buffer = DD->GetBackSurfaceBuffer();
	int scroll_x = (m_ViewX*m_XScrollRatioX1024)>>10;
	int scroll_y = (m_ViewY*m_YScrollRatioX1024)>>10;
	m_Background->Blit(screen_buffer,0,0,XRectangle(scroll_x,scroll_y,scroll_x+m_DirectDrawHandler->GetWidth(),scroll_y+m_DirectDrawHandler->GetHeight()));
	

	


	//  ȿ ׸
	


	

	
	// ȿ ׸

	


	
	DD->ReleaseBackSurfaceBuffer();




	//  ׸
	int screen_width = DD->GetWidth();
	int screen_height = DD->GetHeight();
	XRectangle rectangle1;
	XRectangle rectangle2(m_ViewX,m_ViewY,m_ViewX+screen_width-1,m_ViewY+screen_height-1);
	RECT rect;
	int landview_xcount = m_LandView->GetSmallOffScreenXCount();
	int landview_ycount = m_LandView->GetSmallOffScreenYCount();
	int draw_x = 0, draw_y = 0;
	int i, j;
	XOffScreen *temp;
	LPDIRECTDRAWSURFACE screen_surface = DD->GetBackSurface();
	for(j = 0; j < landview_ycount; j++)
	{
		draw_x = 0;
		for(i = 0; i < landview_xcount; i++)
		{	
			temp = m_LandView->GetSmallOffScreen(i,j);
			// ǥ ϱ..
			if(temp->GetSurface()->IsLost() == DDERR_SURFACELOST)
			{
				rectangle1.left = i*screen_width;
				rectangle1.top = j*screen_height;
				rectangle1.right = rectangle1.left+temp->GetWidth()-1;
				rectangle1.bottom = rectangle1.top+temp->GetHeight()-1;
				temp->GetSurface()->Restore();
				m_Land->Blit(temp->GetBuffer(),0,0,rectangle1);
				temp->ReleaseBuffer();
			}
			rectangle1.left = i*screen_width;
			rectangle1.top = j*screen_height;
			rectangle1.right = i*screen_width+temp->GetWidth()-1;
			rectangle1.bottom = j*screen_height+temp->GetHeight()-1;
			if(rectangle1.CheckCrash(rectangle2) != TRUE) continue;
			rectangle1.ClipEdge(rectangle2);
			rect.left = rectangle1.left-i*screen_width;
			rect.top = rectangle1.top-j*screen_height;
			rect.right = rectangle1.right+1-i*screen_width;
			rect.bottom = rectangle1.bottom+1-j*screen_height;
			screen_surface->BltFast(draw_x,draw_y,temp->GetSurface(),&rect,DDBLTFAST_WAIT | DDBLTFAST_SRCCOLORKEY);
			draw_x += rect.right-rect.left;
		}
		draw_y += rect.bottom-rect.top;
	}

	screen_buffer = DD->GetBackSurfaceBuffer();
	// ũ ׸
	XList<XObject*>::XIterator *iterator;
	m_TankManager->GoFirstElement(&iterator);
	while(m_TankManager->IsEnd(iterator) == FALSE)
	{
		m_TankManager->GetData(iterator)->Draw(screen_buffer);
		m_TankManager->GoNext(&iterator);
	}

	// Ʈ ׸
	m_ItemManager->GoFirstElement(&iterator);
	while(m_ItemManager->IsEnd(iterator) == FALSE)
	{
		m_ItemManager->GetData(iterator)->Draw(screen_buffer);
		m_ItemManager->GoNext(&iterator);
	}

	//ǳڱ׸
	// screen->DrawFillRectangle(50,0,50+tank.GetFireSpeed(),10,15);
	DD->ReleaseBackSurfaceBuffer();
}
