#ifndef _STAGEMANAGER_H
#define _STAGEMANAGER_H

class XStageManager
{
private:
	int m_ViewX, m_ViewY;
	int m_XScrollRatioX1024, m_YScrollRatioX1024;

	XDirectDrawHandler *m_DirectDrawHandler;
	XBuffer *m_Background;
	XBuffer *m_Land;
	XBigOffScreen *m_LandView;

	XList<XObject*> *m_TankManager;
	XList<XObject*> *m_ItemManager;
	XList<XObject*> *m_EffectManager;
	XList<XObject*> *m_BackEffectManager;

	XObject *m_ActiveTank;
	XObject *m_ScrollObject;
public:
	XStageManager();
	virtual ~XStageManager();
	void Create(XDirectDrawHandler *DDH, char *landname, char *backgroundname);

	int GetViewX();
	int GetViewY();
	XDirectDrawHandler *GetDirectDrawHandler();
	XBuffer *GetLand();
	XBuffer *GetBackground();
	XBigOffScreen *GetLandView();
	XList<XObject*> *GetTankManager();
	XList<XObject*> *GetItemManager();
	XObject *GetActiveTank();
	XObject *GetScrollObject();

	void SetViewX(int x);
	void SetViewY(int y);
	void AddTank(XObject *object);
	void AddItem(XObject *object);
	void AddEffect(XObject *object);
	void AddBackEffect(XObject *object);
	void SetActiveTank(XObject *tank);
	void SetScrollObject(XObject *object);

	void Action();
	void Draw(XDirectDrawHandler *DD);
};

#endif