#include "headers.h"

XTank::XTank()
{
	m_Sprite = NULL;
	m_Stage = NULL;
}

XTank::XTank(int x, int y, XImage *sprite, XStageManager *stage)
{
	m_LiveFlag = TRUE;
	m_X = x;
	m_Y = y;
	m_SubX = 0;
	m_SubY = 0;
	m_MaxAngle = 45;
	m_MinAngle = -15;
	m_FireAngle = 30;
	m_Angle = 0;
	m_FireSpeed = 0;
	m_Speed = 100;
	m_Action = TANK_ACTION_DROP;            
	m_PrevAction = TANK_ACTION_REST;          
	m_Sprite = sprite;
	m_Stage = stage;
}

XTank::~XTank()
{
}

int XTank::GetAction()
{
	return m_Action;
}

void XTank::SetActiveMode()
{
	m_Action = TANK_ACTION_MOVE;
}

int XTank::GetFireSpeed()
{
	return m_FireSpeed;
}

void XTank::MoveX(int add)
{
	m_SubX += TrigTable.Cos(m_Angle)*add;
	if(Abs(m_SubX) >= 256*256)
	{
		m_X += m_SubX/(256*256);
		m_SubX %= 256*256;
	}

	XBuffer *land = m_Stage->GetLand();
	int land_width = land->GetWidth();
	char *bottom = land->GetAddress()+m_X+m_Sprite->GetWidth()/2+(m_Sprite->GetHeight())*land_width;
	while(*(bottom+m_Y*land_width) != 0)
		m_Y--;
	if(*(bottom+m_Y*land_width) == 0)
		m_Y++;
	
	if(*(bottom+m_Y*land_width) == 0)
	{
		m_Action = TANK_ACTION_DROP;
		m_PrevAction = TANK_ACTION_MOVE;
		return;
	}

	AngleCheck();
}

void XTank::AngleCheck()
{
	int dir = 0;
	int dx, dy, d;
	int j, i;
	XBuffer *land = m_Stage->GetLand();
	int land_width = land->GetWidth();
	char *bottom = land->GetAddress()+m_X+m_Sprite->GetWidth()/2+(m_Y+m_Sprite->GetHeight())*land_width;

	//   üũ
	if(m_Angle < 90 && m_Angle > -90)
	{
		// Ư 
		if((*(bottom+1-land_width) != 0 && *(bottom-1-land_width) != 0) || (*(bottom+1) == 0 && *(bottom-1) == 0)) { m_Angle = 0; return; }
		// Ʒ üũ
		for(i = 1; i <= m_Sprite->GetWidth()/2; i++)
		{
			if(*(bottom+i) != 0)
			{
				if(*(bottom+i-land_width) != 0) { dir = -1; break; }
			}
			else { dir = 1; break; }
		}

		j = 0;
		dx = m_Sprite->GetWidth()/2+1;
		switch(dir)
		{
		case 1:            // Ʒʰ 
			for(i = 1; i <= m_Sprite->GetWidth()/2; i++)
			{
				if(*(bottom-i+j*land_width) == 0) 
				{ 
					dx = i; 
					break;
				}
				while(*(bottom-i+(j-1)*land_width) != 0)
					j--;
			}
			j = -j;
			break;
		case -1:           // ʰ 
			for(i = 1; i <= m_Sprite->GetWidth()/2; i++)
			{
				if(*(bottom+i+j*land_width) == 0) 
				{ 
					dx = i; 
					break; 
				}
				while(*(bottom+i+(j-1)*land_width) != 0) 
					j--;
			}
			break;
		case 0:           //  
			m_Angle = 0; 
			return;
		}
		dy = -j;
		d = dy*256/dx;
		if(d >= 0)
		{
			for(i = 0; i < 89; i++)
				if(d >= TrigTable.Tan(i) && d < TrigTable.Tan(i+1)) break;
		}
		else
		{
			for(i = 0; i >= -88; i--)
				if(d <= TrigTable.Tan(i) && d > TrigTable.Tan(i-1)) break;
		}
	}
	else    // ʹ üũ
	{
		// Ư 
		if((*(bottom+1-land_width) != 0 && *(bottom-1-land_width) != 0) || (*(bottom+1) == 0 && *(bottom-1) == 0)) { m_Angle = 180; return; }
		// Ʒ üũ
		for(i = 1; i <= m_Sprite->GetWidth()/2; i++)
		{
			if(*(bottom-i) != 0)
			{
				if(*(bottom-i-land_width) != 0) { dir = -1; break; }
			}
			else { dir = 1; break; }
		}

		j = 0;
		dx = -m_Sprite->GetWidth()/2-1;
		switch(dir)
		{
		case 1:            // Ʒʰ 
			for(i = 1; i <= m_Sprite->GetWidth()/2; i++)
			{
				if(*(bottom+i+j*land_width) == 0) 
				{ 
					dx = -i; 
					break;
				}
				while(*(bottom+i+(j-1)*land_width) != 0)
					j--;
			}
			j = -j;
			break;
		case -1:           // ʰ 
		for(i = 1; i <= m_Sprite->GetWidth()/2; i++)
			{
				if(*(bottom-i+j*land_width) == 0) 
				{ 
					dx = -i; 
					break;
				}
				while(*(bottom-i+(j-1)*land_width) != 0)
					j--;
			}
			break;
		case 0:          //  
			m_Angle = 180; 
			return;
		}
		dy = -j;
		d = dy*256/dx;
		if(d >= 0)
		{
			for(i = 180; i < 269; i++)
				if(d >= TrigTable.Tan(i) && d < TrigTable.Tan(i+1)) break;
		}
		else
		{
			for(i = 180; i >= 88; i--)
				if(d <= TrigTable.Tan(i) && d > TrigTable.Tan(i-1)) break;
		}
	}
	m_Angle = i;
}

int XTank::DownCheck()
{
	XBuffer *land = m_Stage->GetLand();

	if(land->GetAddress()[m_X+m_Sprite->GetWidth()/2+
		(m_Y+m_Sprite->GetHeight())*land->GetWidth()] != 0) return TRUE;
	return FALSE;
}

void XTank::ActionRest()
{
	if(DownCheck() == FALSE) 
	{ 
		m_Action = TANK_ACTION_DROP;
		m_PrevAction = TANK_ACTION_REST;
		return;
	}

	if(key[DIK_RIGHT] & 0x80) 
	{
		if(m_Angle > 90 && m_Angle < 270 ) m_Angle -= 180;
	}
	if(key[DIK_LEFT] & 0x80)
	{
		if(m_Angle > -90 && m_Angle < 90) m_Angle += 180;
	}
}

void XTank::ActionMove()
{
	if(DownCheck() == FALSE) 
	{ 
		m_Action = TANK_ACTION_DROP;
		m_PrevAction = TANK_ACTION_MOVE;
		return;
	}

	if(key[DIK_SPACE] & 0x80) 
	{
		m_Action = TANK_ACTION_READYFIRE;
		return;
	}
	if(key[DIK_UP] & 0x80) 
		if(++m_FireAngle > m_MaxAngle) m_FireAngle = m_MaxAngle;
	if(key[DIK_DOWN] & 0x80) 
		if(--m_FireAngle < m_MinAngle) m_FireAngle = m_MinAngle;
	if(key[DIK_RIGHT] & 0x80) 
	{
		if(m_Angle > 90 && m_Angle < 270 ) m_Angle -= 180;
		else MoveX(100);
	}
	if(key[DIK_LEFT] & 0x80)
	{
		if(m_Angle > -90 && m_Angle < 90) m_Angle += 180;
		else MoveX(100);
	}
}

void XTank::ActionDrop()
{
	if(DownCheck() == TRUE)	
	{
		m_Action = m_PrevAction;
		AngleCheck();
	}
	else
	{
		m_Y+=1;
	}
}

void XTank::ActionDead()
{
}

void XTank::ActionReadyFire()
{
	if(key[DIK_SPACE] & 0x80)
	{
		if(++m_FireSpeed >= 500) m_Action = TANK_ACTION_FIRE;
	}
	else m_Action = TANK_ACTION_FIRE;
}

void XTank::ActionFire()
{
	int fire_angle = (m_Angle>90 && m_Angle <270) ? (m_Angle-m_FireAngle) : (m_Angle+m_FireAngle);
	m_Stage->GetItemManager()->AddEnd((XObject*)new XBomb(m_X,m_Y,fire_angle,m_FireSpeed,&bomb_image,m_Stage));

	m_FireSpeed = 0;
	m_Action = TANK_ACTION_REST;         
}

void XTank::Action()
{
	switch(m_Action)
	{
	case TANK_ACTION_REST: ActionRest();
		break;
	case TANK_ACTION_MOVE: ActionMove();
		break;
	case TANK_ACTION_READYFIRE: ActionReadyFire();
		break;
	case TANK_ACTION_FIRE: ActionFire();
		break;
	case TANK_ACTION_DROP: ActionDrop();
		break;
	case TANK_ACTION_DEAD: ActionDead();
		break;
	}
}

void XTank::Draw(XBuffer *target)
{
	int x1, x2, y1, y2;
	x1 = m_X + m_Sprite->GetWidth()/2;
	y1 = m_Y + m_Sprite->GetHeight()/2;
	int fire_angle = (m_Angle>90 && m_Angle <270) ? (m_Angle-m_FireAngle) : (m_Angle+m_FireAngle);
	x2 = x1 + ((TrigTable.Cos(fire_angle)*70)>>8);
	y2 = y1 - ((TrigTable.Sin(fire_angle)*70)>>8);
	target->DrawLine(x1-m_Stage->GetViewX(), y1-m_Stage->GetViewY(), x2-m_Stage->GetViewX(), y2-m_Stage->GetViewY(),15);

	m_Sprite->RotateBlit(target, m_X-m_Stage->GetViewX(), m_Y-m_Stage->GetViewY(), m_Sprite->GetWidth()>>1, m_Sprite->GetHeight()>>1, m_Angle);
	target->DrawPixel(m_X+m_Sprite->GetWidth()/2-m_Stage->GetViewX(), m_Y+m_Sprite->GetHeight()-m_Stage->GetViewY(), rand()%256);
}

