#ifndef _TANK_H
#define _TANK_H

#define TANK_ACTION_REST                 0
#define TANK_ACTION_MOVE                 1
#define TANK_ACTION_READYFIRE            2
#define TANK_ACTION_FIRE                 3
#define TANK_ACTION_DROP                 4
#define TANK_ACTION_DEAD                 5 

class XTank : public XObject
{
private:
	int m_Life;
	int m_FireSpeed;
	int m_Speed;
	int m_Angle;
	int m_SubX, m_SubY;
	int m_MaxAngle, m_MinAngle, m_FireAngle;
public:
	XTank();
	XTank(int x, int y, XImage *sprite, XStageManager *stage);
	virtual ~XTank();
	int GetAction();
	void SetActiveMode();
	int GetFireSpeed();
	void AngleCheck();
	int DownCheck();
	void MoveX(int x);
	void Draw(XBuffer *target);
	void ActionReadyFire();
	void ActionRest();
	void ActionMove();
	void ActionDrop();
	void ActionDead();
	void ActionFire();
	void Action();
};

#endif
