#include <windows.h>
#include <ddraw.h>
#include "ddutil.h"
#include "resource.h"

#define	CLASS_NAME	"My Class"
#define APP_NAME	"My App"

#define SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#define SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }

#define SCREEN_WIDTH    640
#define SCREEN_HEIGHT   480
#define SCREEN_BPP      16

CDisplay*	g_pDisplay	= NULL;
CSurface*	g_pBk	    = NULL;  
BOOL		g_bActive	= FALSE;

HWND		g_hWndEdit;

HRESULT InitDirectDraw( HWND hWnd );
HRESULT RestoreSurfaces();
HRESULT ProcessNextFrame();
VOID    FreeDirectDraw();

LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
    switch( msg )
    {
	case WM_KEYDOWN:
            switch( LOWORD(wParam) )
            {
                case VK_ESCAPE:
                    // Received key/menu command to exit app
            	    PostMessage( hWnd, WM_CLOSE, 0, 0 );
                    return 0L;
			}
	case WM_SIZE:
		if( SIZE_MAXHIDE==wParam || SIZE_MINIMIZED==wParam )
			g_bActive = FALSE;
		else
			g_bActive = TRUE;
		break;
    case WM_DESTROY:
		FreeDirectDraw();
        PostQuitMessage( 0 );
        return 0;
    }
    return DefWindowProc( hWnd, msg, wParam, lParam );
}

INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
    WNDCLASSEX wc = { sizeof(WNDCLASSEX) , 
					  CS_CLASSDC , 
					  MsgProc , 
					  0L , 
					  0L, 
                      GetModuleHandle(NULL),  
					  NULL , 
					  LoadCursor( 0L, IDC_ARROW ) , 
					  (HBRUSH)GetStockObject(WHITE_BRUSH) ,
					  NULL ,
                      CLASS_NAME , 
					  NULL 
					};
	RegisterClassEx( &wc );
	HWND hWnd = CreateWindow( CLASS_NAME , APP_NAME , 
                              WS_POPUP , 0, 0, 640, 480,
                              GetDesktopWindow(), NULL, wc.hInstance, NULL );

    ::ShowWindow( hWnd, SW_SHOWDEFAULT );
    ::UpdateWindow( hWnd );

	if( FAILED ( InitDirectDraw( hWnd ) ) )
		return FALSE;

	g_hWndEdit	=	::CreateWindow( "EDIT" , 
									NULL , 
									WS_POPUP | WS_VISIBLE | ES_AUTOHSCROLL ,
									55 , 207 , 219 , 33 ,
									hWnd, 
									(HMENU)0, 
									hInst , 
									NULL );

	MSG msg; 
    ZeroMemory( &msg, sizeof(msg) );
    while( msg.message!=WM_QUIT )
    {
        if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
        {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
        else
		{
			if( g_bActive )
            {
				static DWORD dwCurTime = 0;
				static DWORD dwPrvTime = 0;
				DWORD  dwElaspedTime = 0;

				dwCurTime = ::timeGetTime();
				dwElaspedTime = dwCurTime - dwPrvTime;

				if( 60 * dwElaspedTime > 1000 )
				{
	                if( FAILED( ProcessNextFrame() ) )
		            {
			            SAFE_DELETE( g_pDisplay );
				        return FALSE;
					}
					dwPrvTime = dwCurTime;
				}
            }
			else
            {
                WaitMessage();
            }
		}
    }
    UnregisterClass( CLASS_NAME , wc.hInstance );
    return 0L;
}

HRESULT InitDirectDraw( HWND hWnd )
{
    HRESULT             hr;
    
	g_pDisplay = new CDisplay();
    if( FAILED( hr = g_pDisplay->CreateFullScreenDisplay( hWnd , SCREEN_WIDTH , SCREEN_HEIGHT , SCREEN_BPP ) ) )
		return hr;

    if( FAILED( hr = g_pDisplay->InitFlipToGDI() ) )
        return hr;

    if( FAILED( hr = g_pDisplay->CreateSurfaceFromBitmap( &g_pBk , 
														  MAKEINTRESOURCE( IDB_BITMAP1 ), 
                                                          640, 480 ) ) )
        return hr;
	return S_OK;
}

HRESULT	DisplayFrame( )
{
    HRESULT hr;
    g_pDisplay->Clear( 0 );

	RECT	rc;
	::SetRect( &rc , 0 , 0 , 640 , 480 );
	g_pDisplay->Blt( 0 , 0 , g_pBk , &rc );
	
    if( FAILED( hr = g_pDisplay->FlipToGDISurface() ) )
        return hr;

    return S_OK;
}

HRESULT RestoreSurfaces()
{
    HRESULT hr;

    if( FAILED( hr = g_pDisplay->GetDirectDraw()->RestoreAllSurfaces() ) )
        return hr;

    if( FAILED( hr = g_pBk->DrawBitmap( MAKEINTRESOURCE( IDB_BITMAP1 ),
                                        640 , 480 ) ) )
        return hr;
    return S_OK;
}

HRESULT ProcessNextFrame()
{
    HRESULT hr;
    if( FAILED( hr = DisplayFrame() ) )
    {
        if( hr != DDERR_SURFACELOST )
            return hr;
        RestoreSurfaces();
    }
    return S_OK;
}

VOID FreeDirectDraw()
{
	::DestroyWindow( g_hWndEdit );
    SAFE_DELETE( g_pBk );
    SAFE_DELETE( g_pDisplay );
}