// AMMap.h: interface for the CAMMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AMMAP_H__6A7B0BF7_C181_41DB_A1E6_50185BD5D7B0__INCLUDED_)
#define AFX_AMMAP_H__6A7B0BF7_C181_41DB_A1E6_50185BD5D7B0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define TILE_WIDTH	40
#define TILE_HEIGHT	40

#define TILESET_WIDTH	16
#define TILESET_HEIGHT	16

#define BASE_TILE	0x00
#define SPRITE_TILE 0x01
#define HIGH_TILE	0x02

struct SMapCell
{
	BYTE cBaseTileSet;
	BYTE cBaseTileNumber;

	BYTE cSpriteTileSet;
	BYTE cSpriteTileNumber;

	WORD wCellAttr;
	WORD wReserved;
};


struct STileSet
{
protected:
	BYTE	cID;
	CDXSurface* m_pTileSurface;
	
public:
	CString strName;
	CString strFilePath;
	int		nUsed;

	STileSet(BYTE _cID)
	{
		cID = _cID;
		s_pTileSet[cID] = this;
		nUsed = 0;
		m_pTileSurface = NULL;
	}
	~STileSet()
	{
		delete m_pTileSurface;
	}
	BOOL LoadTile();
	void ReleaseTile();
	BYTE GetID() {return cID;};
	void DrawTile(int nX, int nY, int nTileNum, CDXSurface* pSurface);
	
	static STileSet* s_pTileSet[256];
	static LPDIRECTDRAW2 s_lpDD;
};

class CAMMap  
{
public:
	void DrawMap2(int nViewX, int nViewY, CDXSurface* pSurface);
	BOOL Create(int nScreenTileWidth, int nScreenTileHeight, LPCTSTR lpszFilePath);
	void DrawMap(int nViewX, int nViewY, CDXSurface* pSurface);
	void SetViewPosition(int nViewTileX, int nViewTileY);
	STileSet* GetTileSet(BYTE cID);
	BOOL LoadMap(LPCTSTR strFilePath);
	CAMMap();
	virtual ~CAMMap();

	SMapCell* m_pMapCell;

	CSize m_sizeMap;
	CString m_strName;
	CString m_strFilePath;
	CList <STileSet*, STileSet*> m_listTileSet;

protected:
	void DrawCellToInterim(int nX, int nY);
	void ScrollVert(int nScroll);
	void ScrollHorz(int nScroll);
	void DrawInterimBuf(int nTX, int nTY);
	CPoint m_ptInterimBase;
	CSize m_szInterimBuf;

	CDXSurface* m_pInterimBuf;
	STileSet* AddTileSet(CString strName, CString strFilePath, BYTE cID);
};

#endif // !defined(AFX_AMMAP_H__6A7B0BF7_C181_41DB_A1E6_50185BD5D7B0__INCLUDED_)
