// DX.h: interface for the CDXDraw class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DX_H__8A800F24_29FD_11D4_A1CB_0000E8EC5D62__INCLUDED_)
#define AFX_DX_H__8A800F24_29FD_11D4_A1CB_0000E8EC5D62__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

struct SDisplayMode
{
	int nWidth;
	int nHeight;
	int nBPP;

	HWND hWnd;
};

struct SMemSurface;
class CDXSurface;

class CDXDraw  
{
	LPDIRECTDRAW2 m_lpDD;
	LPDIRECTDRAWCLIPPER m_lpDDC;

	CDXSurface* m_pDXPrimarySurface;
	CDXSurface* m_pDXBackSurface;

	int		m_nScreenWidth;
	int		m_nScreenHeight;
	int		m_nDisplayWidth;
	int		m_nDisplayHeight;
	int		m_nBPP;
	HWND	m_hWnd;

	BOOL	m_fUseFlip;
	BOOL	m_fFullScreen;

public:
	void Flip();
	CDXSurface* CreateSurface(int nWidth, int nHeight, DWORD dwFlags = 0);
	CDXSurface* CreatePrimarySurface(int nBackBufCount);
	CDXSurface* GetRenderingSurface() {return m_pDXBackSurface;};
	CDXSurface* LoadBitmap(LPCSTR szBitmap);
	LPDIRECTDRAW2 GetDD() {return m_lpDD;};
	
	CDXDraw();
	virtual ~CDXDraw();

	HRESULT Create();
	BOOL SetDisplayMode(SDisplayMode * pDisplayMode, BOOL fFullScreen);

	CDXSurface* CreateSurface(LPDDSURFACEDESC pddsd);
};

class CDXSurface
{
	LPDIRECTDRAWSURFACE3 m_lpDDS;
	CSize m_size;

public:
	void SetColorKey(DWORD dwColor);
	void Unlock();
	DDSURFACEDESC Lock();
	HRESULT Blt(int nX, int nY, CDXSurface* pSrcSurface, CRect rectSrc, DWORD dwFlags = 0);
	void Blt(int nX, int nY, SMemSurface* pSrcSurface, CRect rectSrc);
	CDXSurface* GetBackBufferSurface();
	void CreateFromHandle(LPDIRECTDRAWSURFACE3 lpDDS);
	LPDIRECTDRAWSURFACE3 GetDDS() {return m_lpDDS;};

	CDXSurface();
	virtual ~CDXSurface();
};

struct SMemSurface
{
	LPWORD m_pwSurface;

	int m_nWidth;
	int m_nHeight;

	SMemSurface(int nWidth, int nHeight)
	{
		m_nWidth = nWidth;
		m_nHeight = nHeight;
		m_pwSurface = (LPWORD)malloc(nWidth * nHeight * 2);
	}
	~SMemSurface()
	{
		free(m_pwSurface);
	}
	LPWORD GetAddress(int nX, int nY)
	{return m_pwSurface + nY * m_nWidth + nX;};
	void FillColor(CRect rect, WORD wFillColor);
	void Blt(int nX, int nY, SMemSurface* pSrcSurface, CRect rectSrc);
};

extern LPCTSTR GetDDErrorString(HRESULT hr);

#endif // !defined(AFX_DX_H__8A800F24_29FD_11D4_A1CB_0000E8EC5D62__INCLUDED_)
