// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Test1.h"
#include "dx.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_MOUSEMOVE()
	ON_WM_NCMOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_pMap = NULL;
	m_ptView = CPoint(0, 0);	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	SDisplayMode displayMode;

	displayMode.hWnd = GetSafeHwnd();
	displayMode.nWidth = 800;
	displayMode.nHeight = 600;
	displayMode.nBPP = 16;

	g_DXDraw.Create();
	g_DXDraw.SetDisplayMode(&displayMode, TRUE);
	g_DXDraw.CreatePrimarySurface(1);

	m_pMap = new CAMMap;
	m_pMap->Create(20, 15, "test.map");
	
	m_pMap->SetViewPosition(0, 0);
	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

int nLoop = 0;
int nFrameCnt = 0;

void CMainFrame::UpdateFrame()
{
	static s_dwBaseTick = GetTickCount();
	
	if (m_ptMouse.x <= 10)
		m_ptView.x -= 10;
	else if (m_ptMouse.x >= 790)
		m_ptView.x += 10;
	if (m_ptMouse.y <= 10)
		m_ptView.y -= 10;
	else if (m_ptMouse.y >= 590)
		m_ptView.y += 10;

	if (m_ptView.x < 0)
		m_ptView.x = 0;
	else if (m_ptView.x > m_pMap->m_sizeMap.cx * TILE_WIDTH - 800)
		m_ptView.x = m_pMap->m_sizeMap.cx * TILE_WIDTH - 800;
	if (m_ptView.y < 0)
		m_ptView.y = 0;
	else if (m_ptView.y > m_pMap->m_sizeMap.cy * TILE_HEIGHT - 600)
		m_ptView.y = m_pMap->m_sizeMap.cy * TILE_HEIGHT - 600;

	// Ʒ  ӽù۸  ʱ׸ Դϴ.
	// m_pMap->SetViewPosition(m_ptView.x / TILE_WIDTH, m_ptView.y / TILE_HEIGHT);
	// m_pMap->DrawMap(m_ptView.x, m_ptView.y, g_DXDraw.GetRenderingSurface());

	// Ʒ  ӽù۸    ׸ Դϴ.
	m_pMap->DrawMap2(m_ptView.x / TILE_WIDTH, m_ptView.y / TILE_HEIGHT, g_DXDraw.GetRenderingSurface());


	DrawMiniMap();

	HDC hDC;

	g_DXDraw.GetRenderingSurface()->GetDDS()->GetDC(&hDC);

	CString strFrame;

	strFrame.Format("FPS = %d", nFrameCnt);
	TextOut(hDC, 0, 0, strFrame, strFrame.GetLength());
	g_DXDraw.GetRenderingSurface()->GetDDS()->ReleaseDC(hDC);
	
	g_DXDraw.Flip();
	if (++nLoop > 50)
	{
		DWORD dwTickCount = GetTickCount();
		nFrameCnt = 50000 / (dwTickCount - s_dwBaseTick);
		nLoop = 0;
		s_dwBaseTick = dwTickCount;
	}
}

void CMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();

	if (m_pMap)
		delete m_pMap;
}

void CMainFrame::OnMouseMove(UINT nFlags, CPoint point) 
{
	m_ptMouse = point;
	if (GetCapture() == this)
		SetMiniMapPos(m_ptMouse.x, m_ptMouse.y - 480);
	CFrameWnd::OnMouseMove(nFlags, point);
}

void CMainFrame::OnNcMouseMove(UINT nHitTest, CPoint point) 
{
	m_ptMouse = point;
	CFrameWnd::OnNcMouseMove(nHitTest, point);
}

void CMainFrame::DrawMiniMap()
{
	CDXSurface* pBackSurface = g_DXDraw.GetRenderingSurface();

	DDBLTFX ddBltFX;

	memset(&ddBltFX, 0, sizeof(DDBLTFX));
	ddBltFX.dwSize = sizeof(DDBLTFX);
	ddBltFX.dwFillColor = 0;
	pBackSurface->GetDDS()->Blt(
		CRect(0, 600 - 120, 120, 600),
		NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddBltFX);

	CRect rectView;

	rectView.left = m_ptView.x / 20;
	rectView.top = m_ptView.y / 20 + 600 - 120;
	rectView.right = (m_ptView.x + 800) / 20;
	rectView.bottom = (m_ptView.y + 600) / 20 + 600 - 120;
	ddBltFX.dwFillColor = 0xffe0;
	pBackSurface->GetDDS()->Blt(
		rectView, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddBltFX);
}

void CMainFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if ((point.x >= 0) && (point.x < 120) &&
		(point.y >= 480) && (point.y < 600))
	{
		SetCapture();
		SetMiniMapPos(point.x, point.y - 480);
	}

	CFrameWnd::OnLButtonDown(nFlags, point);
}

void CMainFrame::OnLButtonUp(UINT nFlags, CPoint point) 
{
	ReleaseCapture();
	CFrameWnd::OnLButtonUp(nFlags, point);
}

void CMainFrame::SetMiniMapPos(int nX, int nY)
{
	m_ptView.x = (nX - 20) * 20;
	m_ptView.y = (nY - 15) * 20;
	if (m_ptView.x < 0)
		m_ptView.x = 0;
	else if (m_ptView.x > m_pMap->m_sizeMap.cx * TILE_WIDTH - 800)
		m_ptView.x = m_pMap->m_sizeMap.cx * TILE_WIDTH - 800;
	if (m_ptView.y < 0)
		m_ptView.y = 0;
	else if (m_ptView.y > m_pMap->m_sizeMap.cy * TILE_HEIGHT - 600)
		m_ptView.y = m_pMap->m_sizeMap.cy * TILE_HEIGHT - 600;

}
