#include "stdafx.h"
#include "CharSyam.h"
#include "DirectDraw.h"
#include "Surface.h"
#include "CDD.h"

//DirectDraw.h    
DXDRAW					lpDD;
DXDSURFACE				PrimaryDS;
DXDSURFACE				BackDS;
DDSD2					ddsd;

//Surface.h    
CSurface *PrimarySurface, *BackSurface;
int CDD::InitDDrawFMode(int color, int w, int h)
{
	Width = w;
	Height = h;
	Color = color;

	HRESULT result;
	
	DDSCAPS2 ddscap;

	result = DirectDrawCreateEx(NULL, (LPVOID *)&lpDD, IID_IDirectDraw7, NULL);
	if (result != DD_OK)
		return 0;

	result = lpDD->SetCooperativeLevel( e_hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
	if (result != DD_OK)
		return 0;

	result = lpDD->SetDisplayMode(w , h , color , 0, 0);
	if (result != DD_OK)
		return 0;

	memset( &ddsd , 0 , sizeof(DDSURFACEDESC2));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	result = lpDD->CreateSurface( &ddsd, &PrimaryDS, NULL );
	if (result == DD_OK)
	{
		ZeroMemory( &ddscap , sizeof(ddscap));
		ddscap.dwCaps = DDSCAPS_BACKBUFFER;
		result = PrimaryDS->GetAttachedSurface( &ddscap, &BackDS );
		if (result != DD_OK)
			return 0;
	}

	PrimarySurface = new CSurface;
	BackSurface = new CSurface;

	PrimarySurface->MakeScr(PrimaryDS, w, h);
	BackSurface->MakeScr(BackDS, w, h);

	return 1;
}

void CDD::Destroy()
{
	REMOVE_OBJECT(BackSurface);
	REMOVE_OBJECT(PrimarySurface);
	RELEASE_OBJECT(lpDD);
}

void CDD::Flip()
{
	CSurface *T;

	T = BackSurface;
	BackSurface = PrimarySurface;
	PrimarySurface = T;

	HRESULT result;
	BOOL exitDo = FALSE;
	
	do
	{
		result = PrimaryDS->Flip(NULL, DDFLIP_WAIT);
		if (result == DDERR_SURFACELOST)
			PrimaryDS->Restore();
		else if (result != DDERR_WASSTILLDRAWING)
			exitDo = TRUE;
	}while(!exitDo);
	
	PrimarySurface->lSurface = PrimaryDS;
	BackSurface->lSurface = BackDS;
}

CDD::CDD()
{
	Width = Height = Color = 0;
}

CDD::~CDD()
{
	Destroy();
}