#include "stdafx.h"
#include "CFont.h"

BYTE aabHanCodeTable[3][31]=
{
    {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,0,0,0,0,0,0,0,0,0,},
    {0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21,0,},
    {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,17,18,19,20,21,22,23,24,25,26,27,0,}
};

BYTE aabChoInfo[2][22]=
{
    {0,0,0,0,0,0,0,0,0,1,3,3,3,1,2,4,4,4,2,1,3,0},
    {0,5,5,5,5,5,5,5,5,6,7,7,7,6,6,7,7,7,6,6,7,5}
};

BYTE aabJungInfo[2][20]=
{
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1},
    {0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3}
};

BYTE abJongInfo[22]={0,0,2,0,2,1,2,1,2,3,0,2,1,3,3,1,2,1,3,3,1,1};

#define SINGLENUM	51			/* ѱ   */

WORD Single[SINGLENUM] = {	/* ѱ  51  ڵ */
	0x8841,0x8c41,0x8444,0x9041,0x8446,0x8447,0x9441,0x9841,
	0x9c41,0x844a,0x844b,0x844c,0x844d,0x844e,0x844f,0x8450,
	0xa041,0xa441,0xa841,0x8454,0xac41,0xb041,0xb441,0xb841,
	0xbc41,0xc041,0xc441,0xc841,0xcc41,0xd041,0x8461,0x8481,
	0x84a1,0x84c1,0x84e1,0x8541,0x8561,0x8581,0x85a1,0x85c1,
	0x85e1,0x8641,0x8661,0x8681,0x86a1,0x86c1,0x86e1,0x8741,
	0x8761,0x8781,0x87a1
};

//  ѱ ȯ ڵ 
static BYTE aabHanInfo[0xc8-0xb0+1][0xfe-0xa1+1][2];

int CFONT::LoadInfo(LPSTR szName)
{
	HFILE hFile=_lopen(szName,OF_READ);
		if(hFile==HFILE_ERROR) return 0;
	
		_lread(hFile,aabHanInfo,4700);
	_lclose(hFile);
	return 1;
}

void CFONT::SetColor(int color)
{
	bColor=color;
}

void CFONT::SetMode(int mode)
{
	bMode=mode;
}

void CFONT::SetSurface(CSurface *pSur)
{
	Sur = pSur;
}

void CFONT::PutBit(int Sx,int Sy,WORD *pw)
{
	for(int y=Sy;y<Sy+16;y++)
	{
		WORD Mask=0x8000;
		WORD s=*pw++;
		WORD w=(s<<8)|(s>>8);
		for(int x=Sx;x<Sx+16;x++)
		{
			if(w & Mask)
				Sur->SetPixel(x, y, bColor);
			Mask>>=1;
		}
	}
}

void CFONT::PutBit(int Sx,int Sy,BYTE *pb)
{
	for(int y=Sy;y<Sy+16;y++)
	{
		BYTE Mask=0x80;
		BYTE b=*pb++;
		for(int x=Sx;x<Sx+8;x++)
		{
			if(b & Mask) 
				Sur->SetPixel(x, y, bColor);
			Mask>>=1;
		}
	}
}

void CFONT::Puts(int x,int y,LPSTR szStr)
{
    BYTE *pb=(BYTE*)szStr;
	BYTE abBuf[32];
    while(*pb!=NULL)
    {
        if(*pb & 0x80)
        {	
			WORD wHan;
			// ϼ 
			if(bMode)
			{
				BYTE b1=(*pb++)-0xb0;
				BYTE b2=(*pb++)-0xa1;

				if (b1 == 0xf4 && b2 < SINGLENUM && b2 >= 0)
					wHan=Single[b2];
				else
					wHan=(aabHanInfo[b1][b2][0]<<8)|(aabHanInfo[b1][b2][1]);
			
			}
			//  
			else
			{
				wHan=(*pb++)<<8;
				wHan|=(*pb++);
			}
			
			int ChoCode,JungCode,JongCode;
			int ChoN,JungN,JongN,Chk=0;

			ChoCode =aabHanCodeTable[0][(wHan & 0x7c00)>>10];
			JungCode=aabHanCodeTable[1][(wHan & 0x03e0)>>5];
			JongCode=aabHanCodeTable[2][wHan & 0x001f];

			if(JongCode!=0) Chk=1;

			JongN=abJongInfo[JungCode];
			JungN=aabJungInfo[Chk][ChoCode];
			ChoN =aabChoInfo[Chk][JungCode];
			memcpy(abBuf,aabCho[ChoN][ChoCode],32);
			BYTE *pb;
			if(JungCode)
			{
				pb=aabJung[JungN][JungCode];
				for(int i=0;i<32;i++) abBuf[i]|=pb[i];
			}
			if(JongCode)
			{
				pb=aabJong[JongN][JongCode];
				for(int i=0;i<32;i++) abBuf[i]|=pb[i];
			}

			PutBit(x,y,(WORD*)abBuf);
            x+=16;
        }
        else
        {
            memcpy(abBuf,abEng[*pb++],16);
			PutBit(x,y,abBuf);
            x+=8;
        }
    }
}

void CFONT::Puts2(int x,int y,WORD wHan2)
{
	BYTE abBuf[32];
    	if(1)
        {	
			WORD wHan = wHan2;
			// ϼ 
	/*		if(bMode)
			{
				BYTE b1=(*pb++)-0xb0;
				BYTE b2=(*pb++)-0xa1;
		
				wHan=(aabHanInfo[b1][b2][0]<<8)|(aabHanInfo[b1][b2][1]);
			}
			//  
			else
			{
				wHan=(*pb++)<<8;
				wHan|=(*pb++);
			}
	*/
			
			int ChoCode,JungCode,JongCode;
			int ChoN,JungN,JongN,Chk=0;

			ChoCode =aabHanCodeTable[0][(wHan & 0x7c00)>>10];
			JungCode=aabHanCodeTable[1][(wHan & 0x03e0)>>5];
			JongCode=aabHanCodeTable[2][wHan & 0x001f];

			if(JongCode!=0) Chk=1;

			JongN=abJongInfo[JungCode];
			JungN=aabJungInfo[Chk][ChoCode];
			ChoN =aabChoInfo[Chk][JungCode];
			memcpy(abBuf,aabCho[ChoN][ChoCode],32);
			BYTE *pb;
			if(JungCode)
			{
				pb=aabJung[JungN][JungCode];
				for(int i=0;i<32;i++) abBuf[i]|=pb[i];
			}
			if(JongCode)
			{
				pb=aabJong[JongN][JongCode];
				for(int i=0;i<32;i++) abBuf[i]|=pb[i];
			}

			PutBit(x,y,(WORD*)abBuf);
            x+=16;
        }
//        else
  //      {
    //        memcpy(abBuf,abEng[*pb++],16);
	//		PutBit(x,y,abBuf);
      //      x+=8;
        //}
    
}
int CFONT::LoadEng(LPSTR szName)
{
	HFILE hFile;
	hFile=_lopen(szName,OF_READ);
	if(hFile==HFILE_ERROR) return 0;
		_lread(hFile,abEng,128*16);
	_lclose(hFile);
	return 1;
}

int CFONT::LoadHan(LPSTR szName)
{
	HFILE hFile;
	hFile=_lopen(szName,OF_READ);
	if(hFile==HFILE_ERROR) return 0;
		// ʼ
		_lread(hFile,aabCho,8*20*32);
		// ߼
		_lread(hFile,aabJung,4*22*32);
		// 
		_lread(hFile,aabJong,4*28*32);
	_lclose(hFile);
	return 1;
}

CFONT::CFONT()
{
	SetSurface(BackSurface);
	bColor=255;
	bMode=dHAN_COMPLETE;
	LoadInfo();
	LoadHan();
	LoadEng();
}

CFONT::~CFONT()
{
}

