#include "stdafx.h"
#include "CharSyam.h"
#include "Surface.h"

void SetPalette(LPDIRECTDRAWPALETTE lpDDPal)
{
	PrimaryDS->SetPalette(lpDDPal);
}

LPDIRECTDRAWPALETTE RGB2DDPal(LPRGB *lpRGB)
{
	LPDIRECTDRAWPALETTE lpDDPal;
	PALETTEENTRY PalEntry[256];

	for (int i=0; i < 256; i++)
	{
		PalEntry[i].peBlue = lpRGB[i].b;
		PalEntry[i].peGreen = lpRGB[i].g;
		PalEntry[i].peRed = lpRGB[i].r;
	}

	lpDD->CreatePalette(DDPCAPS_8BIT, PalEntry, &lpDDPal, NULL);
	return lpDDPal;
}
	
CSurface::CSurface()
{
	lPitch = Width = Height = 0;
	lSurface = NULL;
	bCheckLock = 0;
}

CSurface::~CSurface()
{
	DestroyScr();
}

void CSurface::DestroyScr()
{
	RELEASE_OBJECT(lSurface);
}

void CSurface::Lock()
{
	if (bCheckLock != 0)
		bCheckLock++;
	else{
		lSurface->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR, NULL);
		bCheckLock++;
	}
}

void CSurface::Unlock()
{
	if (bCheckLock != 1)
	{
		bCheckLock--;
		return;
	}
	else{
		lSurface->Unlock(NULL);
		bCheckLock = 0;
	}
}

int CSurface::CreateScr(int w, int h, int mode)
{

	ZeroMemory(&ddsd , sizeof(DDSURFACEDESC2));

	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;

	if (mode == MODE_VIDEO)
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	ddsd.dwWidth = w;
	ddsd.dwHeight = h;

	HRESULT t = lpDD->CreateSurface( &ddsd , &lSurface , NULL );
	if (t != DD_OK)
		return 0;

	Width = w;
	Height = h;

	Lock();
	bData = (BYTE *)ddsd.lpSurface;
	SetPitch((WORD)ddsd.lPitch);
	Unlock();

	return 1;
}

void CSurface::PutBlt(int x, int y, CSurface *Target)
{
	RECT t_Rect, s_Rect;
	
	t_Rect.left = x > 0 ? x : 0;
	t_Rect.right = (x + Width) > (Target->Width) ? (Target->Width) : x + Width;
	t_Rect.top = y > 0 ? y : 0;
	t_Rect.bottom = (y + Height) > (Target->Height) ? (Target->Height) : y + Height;

	s_Rect.left = (x >= 0) ? 0 : -x + 1;
	s_Rect.right = (x + Width) > (Target->Width) ? ( Target->Width - x + 1) : Width;
	s_Rect.top = y >=0 ? 0 : -y + 1;
	s_Rect.bottom = (y + Height) > (Target->Height) ? ( Target->Height - y + 1) : Height;
	
	Target->lSurface->Blt( &t_Rect, lSurface, &s_Rect, 0, NULL);
	/*
	RECT t_Rect;

	t_Rect.left = x;
	t_Rect.top = y;
	t_Rect.right = x + Width;
	t_Rect.bottom = y + Height;
	
	Target->lSurface->Blt(&t_Rect, lSurface, NULL , 0 , NULL);
	*/
}

void CSurface::MakeScr(DXDSURFACE t_Surface , int w, int h)
{
	lSurface = t_Surface;
	Width = w;
	Height = h;

	Lock();
	bData = (BYTE *)ddsd.lpSurface;
	SetPitch((WORD)ddsd.lPitch);
	Unlock();
}

void CSurface::Box(int x, int y, int w, int h, int color)
{
	HLine(x, y, w, color);
	HLine(x, y + h - 1 , w, color);
	VLine(x, y, h, color);
	VLine(x + w - 1, y , h , color);
}

void CSurface::Clear(int color)
{
	Bar(0, 0, Width, Height, color);
}

void CSurface::Bar(int x, int y, int w, int h, int color)
{
	for (int t = y; t < y + h; t++)
		HLine(x, t, w, color);
}

void CSurface::SetPixel(int x, int y, int color)
{
	bData[y * lPitch + x] = color;
}

BYTE CSurface::GetPixel(int x, int y)
{
	return bData[(y * lPitch) + x];
}

void CSurface::HLine(int x, int y, int len, int color)
{
	memset( &bData[(y * lPitch) + x] , color , len );
}

void CSurface::VLine(int x, int y, int len, int color)
{
	int t;

	for (t = y; t < (y + len); t++)
		bData[ t * lPitch + x ] = color;

}

int CSurface::LoadPcx(LPSTR ImageFileName, LPDIRECTDRAWPALETTE &lpDDPal)
{
	
	FILE *fp;
	int i_size = 0;
	long l_size = 0;
	long size = 0;

	fp = fopen(ImageFileName, "rb");
	if (fp == NULL)
		return 0;

	i_size = fseek(fp , 0L , SEEK_END);
	if (i_size)
		return 0;

	l_size = ftell(fp);
	if (l_size <= 0)
		return 0;

	i_size = fseek(fp, 0L , SEEK_SET);
	if (i_size)
		return 0;

	PCXHeader pPcxHeader;
	
	fread( &pPcxHeader , 128, 1, fp );

	int w = pPcxHeader.MaxX - pPcxHeader.MinX + 1;
	int h = pPcxHeader.MaxY - pPcxHeader.MinY + 1;

	fseek( fp , 128 , SEEK_SET );
	BYTE *t_dib = new BYTE[l_size - sizeof(PCXHeader)];
	fread(t_dib, l_size - sizeof(PCXHeader), 1 , fp);
	CreateScr(w, h);

	size = 0;
	Lock();

	int i = 0, j = 0;

	for (int y = 0; y < h ; y++)
	{
		for (int x = 0; x < w ; )
		{
			BYTE bCode;
			bCode = (BYTE)t_dib[size++];
			i++;
			j++;
			if ((bCode & 0xc0 ) == 0xc0)
			{
				BYTE bColor;
				int Len = bCode & 0x3f;
				bColor = (BYTE)t_dib[size++];
				HLine(x, y, Len, bColor);
				x += Len;
				i++;
			}
			else
			{
				SetPixel(x, y, bCode);
				x++;
			}
		}
	}

	Unlock();
	
	LPRGB lpRGB[256];
	fseek(fp, -768 , SEEK_END);
	fread(&lpRGB , 768, 1, fp);
	lpDDPal = RGB2DDPal(lpRGB);

    fclose(fp);
	delete t_dib;

	return 1;
}

int CSurface::LoadBmp(LPSTR ImageFileName, LPDIRECTDRAWPALETTE &lpDDPal)
{
	HANDLE fd = CreateFile( ImageFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (fd < 0)
		return 0;

	DWORD size, len;
	LPSTR t_Dib;
	LPSTR m_pDib;

	BITMAPFILEHEADER bmpHeader;
	LPBITMAPINFO pBitmapInfo;

	if (!ReadFile( fd, (LPSTR) &bmpHeader, sizeof(bmpHeader), &len, NULL))
		return 0;

	if (bmpHeader.bfType != BMP_HEADER)
		return 0;

	size = bmpHeader.bfSize - sizeof(bmpHeader);

	t_Dib = new char[size];

	if (!ReadFile(fd, t_Dib, size, &len, NULL))
		return 0;

	if (len != size)
		return 0;

	CloseHandle(fd);
	
	pBitmapInfo = (LPBITMAPINFO) t_Dib;

	if (pBitmapInfo->bmiHeader.biBitCount != 8)
		return pBitmapInfo->bmiHeader.biBitCount;

	int m_ncolor = 256;

	m_pDib = (t_Dib + *(LPDWORD)t_Dib + (m_ncolor * sizeof(RGBQUAD)));
	
	LPRGB lpRGB[256];
	for (int i =0; i < m_ncolor; i++)
	{
		lpRGB[i].b = pBitmapInfo->bmiColors[i].rgbBlue;
		lpRGB[i].g = pBitmapInfo->bmiColors[i].rgbGreen;
		lpRGB[i].r = pBitmapInfo->bmiColors[i].rgbRed;
	}

	lpDDPal = RGB2DDPal(lpRGB);

	int w = pBitmapInfo->bmiHeader.biWidth;
	int h = pBitmapInfo->bmiHeader.biHeight;

	CreateScr(w, h);

	int b_size = 0;
	Lock();

	for (int y = h - 1; y >= 0; y--)
	{
		for (int x=0; x < w; x++)
		{
			SetPixel(x, y, m_pDib[b_size++]);
		}
	}

	Unlock();
	return 1;
}

SPR* CSurface::MakeSpr(int color)
{
	BYTE *abData = new BYTE[Width * Height];
	int x, count;
	int TableN;
	int Offset = 0;

	for (int y = 0; y < Height; y++)
	{
		BYTE *pb = GetData(0, y);
		WORD *pwStart = (WORD *)((BYTE *)abData + Offset);
		Offset += 2;

		TableN = 0;
		x = 0;

		while(1)
		{
			TableN++;

			count = 0;

			for (; x < Width; x++)
			{
				if (pb[x] != color) break;
				else
				{
					if (count == 255) break;
					count++;
				}
			}

			abData[Offset++] = count;

			BYTE *pbSave = pb + x;
			count = 0;

			for (; x < Width ; x++)
			{
				if (pb[x] != color)
				{
					if (count == 255) break;
					count++;
				}
				else break;
			}

			abData[Offset++] = count;

			if (count)
			{
				memcpy(abData + Offset, pbSave, count);
				Offset += count;
			}

			if (x >= Width) break;
		}

		*pwStart = (WORD) TableN;
	}

	SPR *Spr = new SPR;
	Spr->Width = Width;
	Spr->Height = Height;
	Spr->dSize = Offset;
	Spr->bData = new BYTE[Offset];
	memcpy(Spr->bData , abData, Offset);

	delete abData;
	return Spr;
}
	