#include "stdafx.h"
#include "hauto.h"

HAUTO	hauto;

/*****************************************/
// key2Han  Ű  ƽŰڵ - 65	 //
//  빮ڷ ȯ ó		     //
// 쿡 ŰԷ 빮ڷ      //
// ´. a --> A(65) - 65 = 0		 //
// key2Han[0] = 8 ()					 //
/*****************************************/

BYTE key2Han[26] = 	{ 8 , 126 , 16 , 13 , 5 , 7 , 20, 113,			/*a, b, c, d, e, f, g, h, */
					  105, 107, 103, 129, 127, 120, 104, 110,		/*i, j, k, l, m, n, o, p, */
					  9, 2, 4, 11, 111, 19, 14, 18,					/*q, r, s, t, u, v, w, x, */
					  119, 17 };									/*y, z*/

BYTE key2HanShift[26] = { 8, 126, 16, 13, 6, 7, 20, 113,
						  105, 107, 103, 129, 127, 120, 106, 112,
						  10, 3, 4, 12, 111, 19, 15, 18,
						  119, 17};

BYTE choKey[21] = { 0 , 0 , 2 , 3 , 4 , 5 , 6 , 7 ,			/* 0, 0, , , , , ,  */
				  8 , 9 , 10, 11, 12, 13, 14, 15 ,			/* , , , , , , ,  */
				  16, 17, 18, 19, 20 };						/* , , , ,  */

BYTE JungKey[30] = { 0 , 0 , 0 , 3 , 4 , 5 , 6 , 7 ,		/* 0, 0, 0, , , , ,  */
				   0 , 0 , 10, 11, 12, 13, 14, 15,			/* 0, 0, , , , , , */
				   0 , 0 , 18, 19, 20, 21, 22, 23,			/* 0, 0, , , , , , */
				   0 , 0 , 26, 27, 28, 29 };				/* 0, 0, , , , */

BYTE JongKey[30] = { 0 , 0 , 2 , 3 , 4 , 5 , 6 , 7 ,		/* 0, 0, , , , , , */
					8 , 9 , 10, 11, 12, 13, 14, 15,			/* , , , , , , , */
					16, 17, 0 , 19, 20, 21, 22, 23,			/* , , 0, , , , , */
					24, 25, 26, 27, 28, 29};				/* , , , , ,  */

BYTE cho2jong[16][2] = {{2,2}, {3,3}, {4,5}, {5,8},			/*{,},{,},{,},{,}*/
						{7,9}, {8,17}, {9,19}, {11,21},		/*{,},{,},{,},{,}*/
						{12,22}, {13,23}, {14,24}, {16,25},	/*{,},{,},{,},{,}*/
						{17,26}, {18,27}, {19,28}, {20,29}};/*{,},{,},{,},{,}*/

BYTE su2buhoshift[10] = { ')','!','@','#','$','%','^','&','*','(' };

BYTE specialkey[7] = {';','=',',','-','.','/','`'};
BYTE specialkeyshift[7] ={':','+','<','_','>','?','~'};
BYTE specialkey2[4] = {'[','\\',']','\''};
BYTE specialkey2shift[4] = {'{','|','}','"'};

// ߼ ̺
BYTE ddJung[7][3]=
{
    {13,3,14}, /*  += */
    {13,4,15}, /*  += */
    {13,29,18},/*  += */
    {20,7,21}, /*  += */
    {20,10,22},/*  += */
    {20,29,23},/*  += */
    {27,29,28},/*  +=  */
};

BYTE ddjong[11][3]=
{
    {2,11,4},  /* +=*/
    {5,14,6},  /* +=*/
    {5,20,7},  /* +=*/
    {9,2,10},  /* +=*/
    {9,8,11},  /* +=*/
    {9,9,12},  /* +=*/
    {9,11,13}, /* +=*/
    {9,18,14}, /* +=*/
    {9,19,15}, /* +=*/
    {9,20,16}, /* +=*/
    {19,11,20},/* += */
};

HAUTO::HAUTO()
{
	b_count = 0;
	memset(Buf, 0, BUF_SIZE);
	hanin.dummy = 1;
	hanin.firc = 0;
	hanin.midc = 0;
	hanin.lasc = 0;
	IsShift = FALSE;
	IsHan = FALSE;
}

HAUTO::~HAUTO()
{
}

BYTE HAUTO::IsJong(BYTE key)
{
	int i;

	for (i = 0; i < 16; i++)
	{
		if (cho2jong[i][0] == key)
		{
			return cho2jong[i][1];
		}
	}

	return NOCODE;
}

BYTE HAUTO::IsDDJong(BYTE key)
{
	int i;

	for (i = 0; i < 11; i++)
	{
		if (ddjong[i][0] == hanin.lasc && ddjong[i][1] == key)
		{
			return ddjong[i][2];
		}
	}

	return NOCODE;
}

void HAUTO::Ja_Process(BYTE key)
{
	BYTE temp_key;

	if (hanin.firc == EMPTY && hanin.midc == EMPTY)
	{
		hanin.firc = key;
	}
	else if (hanin.firc != EMPTY && hanin.midc == EMPTY)
	{
		CompleteWord();
		hanin.firc = key;
	}
	else if (hanin.midc != EMPTY && hanin.lasc == EMPTY)
	{
		temp_key = IsJong(key);
		if (temp_key == NOCODE)
		{
			CompleteWord();
			hanin.firc = key;
		}
		else{
			hanin.lasc = temp_key;
		}
	}
	else
	{
		if (hanin.lasc != EMPTY)
		{
			temp_key = IsDDJong(key);
			if (temp_key == NOCODE)
			{
				CompleteWord();
				hanin.firc = key;
	
			}
			else{
				hanin.lasc = temp_key;
			}
		}
	}
}

BYTE HAUTO::DDJong2Cho()
{
	int i;

	for (i = 0; i < 11; i++)
	{
		if (ddjong[i][2] == hanin.lasc)
		{
			hanin.lasc = ddjong[i][0];
			return ddjong[i][1];
		}
	}

	return NOCODE;
}

BYTE HAUTO::Jong2Cho(BYTE key)
{
	int i;

	for (i = 0; i < 16; i++)
	{
		if (cho2jong[i][1] == key)
		{
			return cho2jong[i][0];
		}
	}

	return NOCODE;
}

void HAUTO::Mo_Process(BYTE key)
{
	BYTE temp_key;

	if (hanin.lasc != EMPTY)
	{
		temp_key = DDJong2Cho();
		if (temp_key == NOCODE)
		{
			temp_key = hanin.lasc;
			hanin.lasc = EMPTY;
			CompleteWord();
			hanin.firc = Jong2Cho(temp_key);
			hanin.midc = key;
		}
		else
		{
			CompleteWord();
			hanin.firc = temp_key;
			hanin.midc = key;
		}
	}
	else if (hanin.midc == EMPTY){
		hanin.midc = key;
	}
	else if (hanin.midc != EMPTY)
	{
		temp_key = IsDDJung(key);
		if (temp_key == NOCODE)
		{
			CompleteWord();
			hanin.midc = key;
		}
		else
		{
			hanin.midc = temp_key;
		}
	}
}

BYTE HAUTO::IsDDJung(BYTE key)
{
	int i;

	for (i = 0; i < 7; i++)
	{
		if (ddJung[i][0] == hanin.midc && ddJung[i][1] == key)
		{
			return ddJung[i][2];
		}
	}

	return NOCODE;
}
void HAUTO::CompleteWord()
{
	if (hanin.firc == EMPTY && hanin.midc == EMPTY && hanin.lasc == EMPTY)
		return;

	WORD word1 , word2, word3;
	word1 = 0x8000;
	word2 = hanin.firc;
	word2 = word2 << 10;
	word3 = hanin.midc;
	word3 = word3 << 5;

	word1 = word1 | word2 | word3 | hanin.lasc;

	Buf[b_count++] = word1 >> 8;
	Buf[b_count++] = (word1 << 8) >> 8;

	hanin.dummy = 0x8000;
	hanin.firc = 0;
	hanin.lasc = 0;
	hanin.midc = 0;
}

void HAUTO::TempComplete()
{
	if (hanin.firc == EMPTY && hanin.midc == EMPTY && hanin.lasc == EMPTY)
		return;

	WORD word1 , word2, word3;
	word1 = 0x8000;
	word2 = hanin.firc;
	word2 = word2 << 10;
	word3 = hanin.midc;
	word3 = word3 << 5;

	word1 = word1 | word2 | word3 | hanin.lasc;

	Buf[b_count] = word1 >> 8;
	Buf[b_count+1] = (word1 << 8) >> 8;

//	hanin.dummy = 0x8000;
//	hanin.firc = 0;
//	hanin.lasc = 0;
//	hanin.midc = 0;
}
void HAUTO::GetKey(BYTE key)
{
	if (key - ASCIICODE >= 0 && key - ASCIICODE <= 25)
	{
		if (IsHan){
			if (!IsShift)
				key = key2Han[key - ASCIICODE];
			else
				key = key2HanShift[key - ASCIICODE];

			if (key > 100)
			{
				key -= MID_OFF;
				Mo_Process(key);
			}
			else
				Ja_Process(key);
		}
		else
		{
			if (IsShift == FALSE)
			{
				CompleteWord();
				Buf[b_count++] = key + 32;
			}
			else
			{
				CompleteWord();
				Buf[b_count++] = key;
			}
		}
	}
	else{
		if (key == VK_SPACE && !IsShift)
		{
			CompleteWord();
			Buf[b_count++] = ' ';
		}
		else if (key == VK_SPACE && IsShift)
		{
			IsHan = !IsHan;
		}
		else if (key == 16)
		{
			IsShift = TRUE;
		}
		else if (key == VK_BACK)
			BS_Process();
		else
		{
			if (key >= 48 && key < 58)
			{
				if (IsShift){
					CompleteWord();
					Buf[b_count++] = su2buhoshift[key - 48];
				}
				else{
					CompleteWord();
					Buf[b_count++] = key;
				}
			}
			else if (key >= 186 && key < 193)
			{
				if (IsShift)
				{
					CompleteWord();
					Buf[b_count++] = specialkeyshift[key - 186];
				}
				else
				{
					CompleteWord();
					Buf[b_count++] = specialkey[key - 186];
				}
			}
			else if (key > 218 && key < 223)
			{
				if (IsShift)
				{
					CompleteWord();
					Buf[b_count++] = specialkey2shift[key - 219];
				}
				else
				{
					CompleteWord();
					Buf[b_count++] = specialkey2[key -219];
				}
			}
			else{
				return;
			}
		}
	}
	TempComplete();
//	char buff[512];
//	sprintf(buff, "%d %d %d %d", hanin.dummy, hanin.firc, hanin.midc, hanin.lasc);
//	MessageBox(hWnd, buff, "test", 0);

}

int HAUTO::IsHangul()
{
	int i;
	int t;
	for (i = 0; i < b_count;)
	{
		if (Buf[i] & 0x80)
		{
			i = i + 2;
			t = BYTE2;
		}
		else{
			i++;
			t = BYTE1;
		}
	}

	return t;
}

BYTE HAUTO::IsDDJong2()
{
	int i;

	for (i = 0; i < 11; i++)
	{
		if (ddjong[i][2] == hanin.lasc)
		{
			return ddjong[i][0];
		}
	}

	return NOCODE;
}

BYTE HAUTO::IsDDJung2()
{
	int i;

	for (i = 0; i < 7; i++)
	{
		if (ddJung[i][2] == hanin.midc)
		{
			return ddJung[i][0];
		}
	}

	return NOCODE;
}

void HAUTO::BS_Process()
{
	int t_Check;

	if (hanin.firc == EMPTY && hanin.midc == EMPTY && hanin.lasc == EMPTY)
	{
		if (b_count == 0)
			return;

		t_Check = IsHangul();

		if (t_Check == BYTE1)
		{
			Buf[--b_count] = '\0';
		}
		else{
			Buf[--b_count] = '\0';
			Buf[--b_count] = '\0';
		}
	}
	else if (hanin.lasc != EMPTY)
	{
		WORD temp_key;
		temp_key = IsDDJong2();
		if (temp_key == NOCODE)
		{
			hanin.lasc = EMPTY;
		}
		else
		{
			hanin.lasc = temp_key;
		}
	}
	else if (hanin.lasc == EMPTY && hanin.midc != EMPTY)
	{
		WORD temp_key;
		temp_key = IsDDJung2();
		if (temp_key == NOCODE)
		{
			hanin.midc = EMPTY;
		}
		else
		{
			hanin.midc = temp_key;
		}
	}
	else if (hanin.firc != EMPTY){
		hanin.firc = EMPTY;
		Buf[b_count] = '\0';
	}
}

