#ifndef		__SURFACE_H__
#define		__SURFACE_H__

#include "DirectDraw.h"

#define MODE_VIDEO		1
#define MODE_SYSTEM		2

#define BMP_HEADER		((WORD) ('M' << 8 ) | 'B')

class CSurface{
//Variable
private:
	BYTE *bData;
	WORD lPitch;
	BYTE bCheckLock;

public:
	DXDSURFACE lSurface;
	WORD Width, Height;
	

//Operation

public:
	CSurface();
	~CSurface();
	void SetPitch(WORD t_pitch){ lPitch = t_pitch; }
	WORD GetPitch(){ return lPitch; }
	BYTE* GetData(int x = 0, int y = 0){ return &bData[y * lPitch + x]; }

	void Lock();
	void Unlock();
	int CreateScr(int w, int h, int mode = MODE_SYSTEM);
	void DestroyScr();

	void MakeScr(DXDSURFACE t_Surface, int w, int h);
	void PutBlt(int x, int y, CSurface *Target);

	void Clear(int color = 0);

	//Normal Graphic -- Need Lock and Unlock function
	void SetPixel(int x, int y, int color);
	BYTE GetPixel(int x, int y);

	void HLine(int x, int y, int len, int color);
	void VLine(int x, int y, int len, int color);
	void Box(int x, int y, int w, int h, int color);
	void Bar(int x, int y, int w, int h, int color);

	//Image Loading Function
	int LoadPcx(LPSTR ImageFileName, LPDIRECTDRAWPALETTE& lpDDPal);
	int LoadBmp(LPSTR ImageFileName, LPDIRECTDRAWPALETTE& lpDDPal);
//	int LoadPcx2(LPSTR ImageFileName, LPDIRECTDRAWPALETTE& lpDDPal);

	//Sprite
	SPR* MakeSpr(int color = 0);
};

extern CSurface *PrimarySurface , *BackSurface;

#endif


