#include <malloc.h>
#include <memory.h>
#include "Rogue.h"
#include "DDUtil.h"

extern TApplication Application;

LPDDraw lpdraw = NULL;

static BOOL DDCreateSurfaces();

LPDIRECTDRAW DDCreate(HWND hwndApp)
{
	HRESULT hr;

	if( lpdraw != NULL )
		DDDestroy();

	if( (lpdraw = (LPDDraw)malloc(sizeof(DDraw))) == NULL )
		return NULL;
	memset(lpdraw,0,sizeof(DDraw));

    hr = DirectDrawCreate( NULL, &lpdraw->lpdd, NULL );
	if( hr == DD_OK )
	{
		lpdraw->hwndApp = hwndApp;

		lpdraw->nCooperation = DDSCL_EXCLUSIVE |
							   DDSCL_FULLSCREEN;

		lpdraw->cx = 800;
		lpdraw->cy = 600;
		lpdraw->bbp = 8;
		lpdraw->nBuffers = 2;

	} else {
		free(lpdraw);
		lpdraw = NULL;
		return NULL;
	}
	return lpdraw->lpdd;
}

void DDDestroy()
{
	if( lpdraw == NULL )
		return;
	if( lpdraw->lpdd != NULL )
		lpdraw->lpdd->Release();
	free(lpdraw);
	lpdraw = NULL;
}


BOOL DDEnable()
{
	HRESULT hr;

	if( lpdraw == NULL )
		return FALSE;

	hr = lpdraw->lpdd->SetCooperativeLevel( lpdraw->hwndApp, lpdraw->nCooperation );
	if( hr != DD_OK )
		return FALSE;

	if( lpdraw->nCooperation & DDSCL_EXCLUSIVE )
	{
		hr = lpdraw->lpdd->SetDisplayMode( lpdraw->cx, lpdraw->cy, lpdraw->bbp );
		if( hr != DD_OK )
			return FALSE;
	}
	else
	{
        RECT	rcWork;
        RECT	rc;
        HDC		hdc;

        hdc = GetDC(NULL);
        lpdraw->bbp = GetDeviceCaps(hdc, PLANES) * GetDeviceCaps(hdc, BITSPIXEL);
        ReleaseDC(NULL, hdc);

        SetRect(&rc, 0, 0, lpdraw->cx, lpdraw->cy);

        AdjustWindowRectEx(&rc,
            GetWindowStyle(lpdraw->hwndApp),
            GetMenu(lpdraw->hwndApp) != NULL,
            GetWindowExStyle(lpdraw->hwndApp));

        SetWindowPos(lpdraw->hwndApp, NULL, 0, 0, rc.right-rc.left, rc.bottom-rc.top,
            SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);

        SetWindowPos(lpdraw->hwndApp, HWND_NOTOPMOST, 0, 0, 0, 0,
            SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);

        SystemParametersInfo(SPI_GETWORKAREA, 0, &rcWork, 0);
        GetWindowRect(lpdraw->hwndApp, &rc);
        if (rc.left < rcWork.left) rc.left = rcWork.left;
        if (rc.top  < rcWork.top)  rc.top  = rcWork.top;
        SetWindowPos(lpdraw->hwndApp, NULL, rc.left, rc.top, 0, 0,
            SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
	}
	return DDCreateSurfaces();
}

void DDDisable()
{
	if( lpdraw == NULL )
		return;

    for (int i = 0; i < MAX_IMAGE_BUFFER; i++) 
	{
 		if( lpdraw->lpImageBuffer[i] )
		{
			lpdraw->lpImageBuffer[i]->Release();
			lpdraw->lpImageBuffer[i] = NULL;
		}
	}

    if( lpdraw->lpBackBuffer )
    {
        lpdraw->lpBackBuffer->Release();
        lpdraw->lpBackBuffer = NULL;
    }

    if( lpdraw->lpFrontBuffer )
    {
		lpdraw->lpFrontBuffer->Release();
        lpdraw->lpFrontBuffer = NULL;
    }

	if( lpdraw->lpClipper) 
	{
		lpdraw->lpClipper->Release();
		lpdraw->lpClipper = NULL;
	}

	if( lpdraw->nCooperation & DDSCL_EXCLUSIVE )
		lpdraw->lpdd->RestoreDisplayMode();
}

int DDGetWidth()
{
	return lpdraw->cx;
}

int DDGetHeight()
{
	return lpdraw->cy;
}

BOOL DDSetCooperativeLevel(int level)
{
   BOOL fWasEnabled = lpdraw->fEnabled;

   if( fWasEnabled )
      DDDisable();

   lpdraw->nCooperation = level;

   if( fWasEnabled )
      DDEnable();
   return TRUE;
}

int DDGetCooperativeLevel()
{
	return lpdraw->nCooperation;
}

LPDIRECTDRAWSURFACE	DDGetFrontBuffer()
{
	if( lpdraw == NULL )
		return NULL;
	return lpdraw->lpFrontBuffer;
}

LPDIRECTDRAWSURFACE	DDGetBackBuffer()
{
	if( lpdraw == NULL )
		return NULL;
	return lpdraw->lpBackBuffer;
}

LPDIRECTDRAWSURFACE	DDGetImageBuffer(int Number)
{
	if ( Number >= 0 && Number < MAX_IMAGE_BUFFER ) 
	{
		if( lpdraw == NULL )
			return NULL;
		return lpdraw->lpImageBuffer[Number];
	}
	else 
	{
		return NULL;
	}
}

static BOOL DDCreateSurfaces()
{
	LPDIRECTDRAW		lpdd = lpdraw->lpdd;
    DDSURFACEDESC       ddsd;
    HRESULT             hr;
    DDSCAPS             ddscaps;


    memset( (VOID *)&ddsd, 0, sizeof( ddsd ) );
    ddsd.dwSize = sizeof( ddsd );

    if ( lpdraw->nCooperation & DDSCL_FULLSCREEN )
    {
        ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
        ddsd.dwBackBufferCount = lpdraw->nBuffers-1;
        ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                DDSCAPS_FLIP | DDSCAPS_COMPLEX;

        hr = lpdd->CreateSurface(
					&ddsd, 
					&lpdraw->lpFrontBuffer, 
					NULL );

        if( hr != DD_OK )
            return FALSE;

        ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
        hr = lpdraw->lpFrontBuffer->GetAttachedSurface(
					&ddscaps,
                    &lpdraw->lpBackBuffer );

        if( hr != DD_OK )
			return FALSE;
	}
	else 
	{
        ddsd.dwFlags = DDSD_CAPS;
        ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

        hr = lpdd->CreateSurface( &ddsd, &lpdraw->lpFrontBuffer, NULL );

        if( hr != DD_OK )
            return FALSE;

        lpdraw->lpBackBuffer = DDCreateSurface( lpdraw->cx, lpdraw->cy, FALSE );

        if( lpdraw->lpBackBuffer == NULL )
            return FALSE;

        hr = lpdd->CreateClipper(0, &lpdraw->lpClipper, NULL);

        if( hr != DD_OK )
            return FALSE;

        hr = lpdraw->lpClipper->SetHWnd(0, lpdraw->hwndApp);

        if( hr != DD_OK )
            return FALSE;

        hr = lpdraw->lpFrontBuffer->SetClipper(lpdraw->lpClipper);

        if( hr != DD_OK )
            return FALSE;
	}

	FillBufferRect(lpdraw->lpBackBuffer, NULL, RGB(0,0,0));

	lpdraw->lpImageBuffer[1] = DDCreateSurface( 640, 480, TRUE );
	lpdraw->lpImageBuffer[1] = DDLoadBitmap(lpdd, "Deja1.BMP", 640, 480);
	DDSetColorKey(lpdraw->lpImageBuffer[1],0);

	lpdraw->lpImageBuffer[2] = DDCreateSurface( 640, 480, TRUE );
	lpdraw->lpImageBuffer[2] = DDLoadBitmap(lpdd, "Deja2.BMP", 640, 480);
	DDSetColorKey(lpdraw->lpImageBuffer[2],0);

	return TRUE;
}

LPDIRECTDRAWSURFACE DDCreateSurface(DWORD width, DWORD height, BOOL sysmem )
{
    DDSURFACEDESC       ddsd;
    HRESULT             hr;
    LPDIRECTDRAWSURFACE lpSurface;

    memset( &ddsd, 0, sizeof( ddsd ) );
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH;

    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    if( sysmem )
        ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    ddsd.dwHeight = height;
    ddsd.dwWidth = width;

    hr = lpdraw->lpdd->CreateSurface( &ddsd, &lpSurface, NULL );

	if( hr != DD_OK )
		lpSurface = NULL;
	return lpSurface;
}

BOOL IsFullScreenMode()
{
	return (DDGetCooperativeLevel() & DDSCL_FULLSCREEN);
}


BOOL MakeItSo(HRESULT DDResult)
{
	switch (DDResult)
	{
		case DD_OK             : return TRUE;
//		case DDERR_SURFACELOST : return (RestoreSurfaces <> DD_OK);
		default                : return (DDResult != DDERR_WASSTILLDRAWING);
	}
}

BOOL DDFlip()
{
	HRESULT hr;

	if( lpdraw->nCooperation & DDSCL_FULLSCREEN )
	{
		hr = lpdraw->lpFrontBuffer->Flip(NULL,DDFLIP_WAIT);
	} 
	else 
	{
//		hr = lpdraw->lpdd->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN,0);
		hr = lpdraw->lpFrontBuffer->Blt(
							&Application.wndRect,
							lpdraw->lpBackBuffer,
							NULL,
							DDBLT_WAIT,
							NULL);
	}
    return hr == DD_OK;
}


CBitmap::CBitmap(const char* FileName)
{
	DDSURFACEDESC DDSurfaceDesc;

	Buffer = DDLoadBitmap(lpdraw->lpdd, FileName, 0, 0);
	if (Buffer)
	{
		memset(&DDSurfaceDesc,0,sizeof(DDSurfaceDesc));
		DDSurfaceDesc.dwSize = sizeof(DDSurfaceDesc);
		DDSurfaceDesc.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
		Buffer->GetSurfaceDesc(&DDSurfaceDesc);
		Size.x = DDSurfaceDesc.dwWidth;
		Size.y = DDSurfaceDesc.dwHeight;
	}
	else 
	{
		Size.x = 0;
		Size.y = 0;
	}
}
CBitmap::~CBitmap()
{
	if (Buffer)
	{
		Buffer->Release();
		Buffer = NULL;
	}
}
void CBitmap::Draw(int x, int y)
{
	do { }
	while (!MakeItSo(lpdraw->lpBackBuffer->BltFast(x,y,Buffer,NULL,DDBLTFAST_NOCOLORKEY)));
}

void CBitmap::DrawTile(RECT Area)
{
	RECT rect;

	Area.top += 2;
	Area.right -= 2;
	Area.bottom -= 2;

	int XLen = (Area.right - Area.left) / Size.x;
	int YLen = (Area.bottom - Area.top) / Size.y;

	for (int j = 0; j <= YLen; j++)
	{
		for (int i = 0; i <= XLen; i++)
		{
			if ((i < XLen) && (j < YLen))
			{
				Draw(i*Size.x + Area.left, j*Size.y + Area.top);
			}
			else
			{
				rect.left = 0;
				rect.top = 0;
				rect.right = (Area.right - Area.left) - i * Size.x;
				rect.bottom = (Area.bottom - Area.top) - j * Size.y;
				if (rect.right > Size.x)
					rect.right = Size.x;
				if (rect.bottom > Size.y)
					rect.bottom = Size.y;
				do { }
				while (!MakeItSo(lpdraw->lpBackBuffer->BltFast(i*Size.x +  Area.left, j*Size.y + Area.top,
						Buffer,&rect,DDBLTFAST_NOCOLORKEY)));
			}
		}
	}
}
