#ifndef __DDRAWEX_H

#define __DDRAWEX_H

#include <windows.h>
#include <DDraw.h>

#define MAX_IMAGE_BUFFER 5

typedef struct _DDraw
{
	HWND				hwndApp;
	LPDIRECTDRAW		lpdd;
	LPDIRECTDRAWSURFACE	lpFrontBuffer;
	LPDIRECTDRAWSURFACE	lpBackBuffer;
	LPDIRECTDRAWSURFACE	lpImageBuffer[MAX_IMAGE_BUFFER];
	LPDIRECTDRAWCLIPPER	lpClipper;
	BOOL				fEnabled;
	BOOL				fFullScreen;
	int					nCooperation;
	int					cx;
	int					cy;
	int					bbp;
	int					nBuffers;
} DDraw, *LPDDraw;

LPDIRECTDRAW		DDCreate(HWND hwndApp);
void				DDDestroy();
BOOL				DDEnable();
void				DDDisable();
LPDIRECTDRAWSURFACE	DDGetFrontBuffer();
LPDIRECTDRAWSURFACE	DDGetBackBuffer();
LPDIRECTDRAWSURFACE	DDGetImageBuffer(int Number);
int					DDGetWidth();
int					DDGetHeight();
LPDIRECTDRAWSURFACE DDCreateSurface(DWORD width, DWORD height, BOOL sysmem );
BOOL				MakeItSo(HRESULT DDResult);
BOOL				IsFullScreenMode();
BOOL				DDFlip();
BOOL				DDSetCooperativeLevel(int level);
int					DDGetCooperativeLevel();

class CBitmap
{
	public:
		CBitmap(const char* FileName);
		~CBitmap();

		POINT Size;
		LPDIRECTDRAWSURFACE Buffer;

		void Draw(int x, int y);
		void DrawTile(RECT Area);
};

#endif

