
#define _USE_DIRECT_DRAW

#include "Rogue.h"
#include "USys.h"
#include "UMain.h"

TApplication Application;

extern CMain *Main;
extern CGameSystem *GameSystem;

static BOOL WinInit( HINSTANCE hInst, int nCmdShow );
static BOOL DrawInit(void);

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG	msg;

	memset((void *)&Application, 0, sizeof(Application) );

	if( !WinInit( hInstance, nCmdShow ) )
		return FALSE;

#ifdef _USE_DIRECT_DRAW

	if( !DrawInit() )
		return FALSE;

#endif

    while( 1 )
    {
		if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
        {
			if( !GetMessage( &msg, NULL, 0, 0 ) )
                return msg.wParam;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        } 
		else 
		{
			PostMessage(Application.hwndApp,WM_IDLE,0,0);
			WaitMessage();
        }
    }
}

static long FAR PASCAL WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    PAINTSTRUCT ps;
    HDC         hdc;

    switch( message )
    {
		case WM_IDLE:

#ifdef _USE_DIRECT_DRAW

			if( Application.fFlippingPaused == FALSE )
				MainProc();
#endif
			break;
		case WM_SIZE:
		case WM_MOVE:
			GetClientRect(Application.hwndApp, &Application.wndRect);
			ClientToScreen(Application.hwndApp, (LPPOINT)&Application.wndRect);
			ClientToScreen(Application.hwndApp, (LPPOINT)&Application.wndRect+1);
			break;
		case WM_ENTERMENULOOP:
			Application.fFlippingPaused = TRUE;
			Application.lpDirectDraw->FlipToGDISurface();
		    DrawMenuBar(Application.hwndApp);
			RedrawWindow(Application.hwndApp, NULL, NULL, RDW_FRAME);
			break;
		case WM_EXITMENULOOP:
			Application.fFlippingPaused = FALSE;
			break;
		case WM_LBUTTONUP :
		case WM_RBUTTONUP :
		case WM_LBUTTONDOWN :
		case WM_RBUTTONDOWN :
		case WM_MOUSEMOVE :
//			GameSystem->ProcessButton(message);
			break;
		case WM_KEYDOWN:
			switch( wParam )
			{
				case VK_ESCAPE:
				case VK_F12   :
					PostMessage(hWnd, WM_CLOSE, 0, 0);
					return 0;
				case VK_F1    :
					MessageBox(hWnd,"!!!","Caption",MB_YESNOCANCEL);
					break;
				case VK_RETURN :
//					GameSystem->MakePopupMenu();
					break;
			}
			Application.KeyCode = wParam;
			break;
		case WM_SYSKEYUP:
			switch( wParam )
			{
				case VK_RETURN:
				{
					int nCooperation = DDGetCooperativeLevel();

					DDDisable();
					if( nCooperation & DDSCL_FULLSCREEN )
						DDSetCooperativeLevel( DDSCL_NORMAL );
					else
						DDSetCooperativeLevel( DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
					DDEnable();
					break;
				}
			}
			break;
		case WM_PAINT:
			hdc = BeginPaint( hWnd, &ps );
			EndPaint( hWnd, &ps );
			return 1;
		case WM_DESTROY:

#ifdef _USE_DIRECT_DRAW

			FinalizeMain();

			DDDisable();
			DDDestroy();

#endif
			PostQuitMessage( 0 );
			break;
    }
    return DefWindowProc(hWnd, message, wParam, lParam);
}

static BOOL WinInit( HINSTANCE hInstance, int nCmdShow )
{
	WNDCLASS    wc;
	BOOL        rc;

	Application.hinst = hInstance;

	wc.style = CS_DBLCLKS;
	wc.lpfnWndProc = WindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
//	wc.hIcon = LoadIcon(hInstance, MAKEINTATOM(IDI_GDKAPP));
	wc.hIcon = NULL;
	wc.hCursor = LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName =  "SMgalDxMenu";
	wc.lpszClassName = "SMgalDxTestClass";
	rc = RegisterClass( &wc );
    if( !rc )
        return FALSE;

    Application.hwndApp = 
		CreateWindowEx(
			WS_EX_APPWINDOW,
			"SMgalDxTestClass",
			" Deja Win",
			WS_VISIBLE,// | WS_OVERLAPPEDWINDOW,
			0,
			0,
			0,//640,
			0,//480,
			NULL,
			NULL,
			hInstance,
			NULL );

    if( Application.hwndApp == NULL )
        return FALSE;

	ShowCursor(FALSE);

    UpdateWindow( Application.hwndApp );
    SetFocus( Application.hwndApp );

    return TRUE;
}

static BOOL DrawInit()
{
	if( (Application.lpDirectDraw = DDCreate(Application.hwndApp)) == NULL )
		return FALSE;
	DDSetCooperativeLevel( DDSCL_NORMAL );

	if( DDEnable() == FALSE )
		return FALSE;

	InitilizeMain();

	return TRUE;
}
