
#include <stdlib.h>
#include "Rogue.h"
#include "DDrawEx.h"
#include "DDUtil.h"
#include "UCompo.h"
#include "USys.h"

/* Start of CEventQueue */

CEventQueue::CEventQueue()
{
	ClearEvent();

	m_queue_size = MAX_EVENT_QUEUE;
	Queue = (TEventData *)malloc(m_queue_size * sizeof(TEventData));
}

CEventQueue::~CEventQueue()
{
	free(Queue);
}

int CEventQueue::PrevPtr(int value)
{
	return (value > 0) ? (MAX_EVENT_QUEUE-1):(value - 1);
}

int CEventQueue::NextPtr(int value)
{
	return (value < (MAX_EVENT_QUEUE-1)) ? (value + 1):(0);
}

BOOL CEventQueue::PushEvent(TEventData *EventMessage)
{
	if (m_head == NextPtr(m_tail)) 
		return FALSE;

	Queue[m_tail] = *EventMessage;
	m_tail = NextPtr(m_tail);

	return TRUE;
}

BOOL CEventQueue::UrgentPushEvent(TEventData *EventMessage)
{
	if (PrevPtr(m_head) == m_tail) 
		return FALSE;

	m_head = PrevPtr(m_head);
	Queue[m_head] = *EventMessage;

	return TRUE;
}

BOOL CEventQueue::PopEvent(TEventData *EventMessage)
{
	if (m_head == m_tail)
		return FALSE;

	*EventMessage = Queue[m_head];
	m_head = NextPtr(m_head);

	return TRUE;
}

void CEventQueue::ClearEvent()
{
	m_head = 0;
	m_tail = 0;
}

BOOL CEventQueue::CheckEvent(TEventData *EventMessage)
{
	return FALSE;
}

BOOL CEventQueue::DeleteEvent(TEventData *EventMessage)
{
	return FALSE;
}

/* End of CEventQueue */

