
#include <ddraw.h>
#include <time.h>
#include "DDrawEx.h"
#include "Rogue.h"
#include "UTypes.h"
#include "USys.h"
#include "UMain.h"
#include "UCompo.h"

CMain *Main = NULL;
CGameSystem *GameSystem = NULL;

extern TApplication Application;

extern long _ABS_X;
extern long _ABS_Y;

CMain::CMain()
{
}

CMain::~CMain()
{
	Finalize();
}

void   CMain::Initialize()
{
	Map = new CMap();
//	Map->LoadFromFile("Abellis.Maf");
	Map->LoadFromFile("Roperr.Maf");

	for (int i = 0; i <= MAX_PERSON; i++)
		Person[i] = NULL;

	Person[1] = new CCharacter(1,75,25, 1,fdRight,mnNotNeed,maPerson,8);
	Person[2] = new CCharacter(2,73,25,15,fdLeft ,mnNotNeed,maPerson,8);
	Person[2]->mTransparency = 25;
	Person[3] = new CCharacter(3,75,27,18,fdDown ,mnNotNeed,maPerson,8);
	Person[3]->mTransparency = 50;

	GameSystem = new CGameSystem();
	GameSystem->StartTickCount = GetTickCount();
}

void   CMain::Finalize()
{
	for (int i = 1; i < MAX_PERSON; i++)
	{
		if (Person[i])
		{
			delete Person[i];
			Person[i] = NULL;
		}
	}

	delete Map;
	Map = NULL;

	delete GameSystem;
	GameSystem = NULL;
}

/**
  * <<    >>
  *
  * 1. Ÿ
  * 2.  Ʈ       ->   Ÿϰ   
  *    ( Ʈ      )
  * 3. ü   ü
  * 4.   Ʈ  ->   Ÿ 
  *    (  ʿ  Fetch  )
  * 5.  ִ ü    ->   Ÿϰ   
  *                             Ÿϰ    ( y-1 ϶ )
  *    ( ü Ӽ   ٸ   )
  * 6. 帷 Ʈ       ->   Ÿϰ 
  **/

void   CMain::DrawScreen()
{
	WORD SCREEN_X_MAX = 27;
	WORD SCREEN_Y_MAX = 20;

	int   x, y;
	BYTE  value;
	POINT Pitch;
	POINT Origin;

/*
	ȭ 
*/
	SCREEN_X_MAX = (MAX_X_LINE + Pred(TILE_X_SIZE)) / TILE_X_SIZE;
	SCREEN_Y_MAX = (MAX_Y_LINE + Pred(TILE_Y_SIZE)) / TILE_Y_SIZE;
/*
	SCREEN_X_MAX = Succ(VIEW_WIDE_X * 2);
	SCREEN_Y_MAX = Succ(VIEW_WIDE_Y * 2);
*/
	Origin.x     = (MAX_X_LINE / TILE_X_SIZE) - SCREEN_X_MAX;
	Origin.y     = 0;

	Pitch	= Point(Person[GameSystem->MAIN_CHARACTER]->mX - SCREEN_X_MAX / 2 - Origin.x ,
					Person[GameSystem->MAIN_CHARACTER]->mY - SCREEN_Y_MAX / 2 - Origin.y);

	if (Pitch.x < 0)  
		Pitch.x = 0;
	if (Pitch.y < 0)
		Pitch.y = 0;
	if (Pitch.x > Map->MapSize.x - SCREEN_X_MAX)
		Pitch.x = Map->MapSize.x - SCREEN_X_MAX;
	if (Pitch.y > Map->MapSize.y - SCREEN_Y_MAX)
		Pitch.y = Map->MapSize.y - SCREEN_Y_MAX;

	for (int _y = 0; _y < SCREEN_Y_MAX; _y++) 
	for (int _x = 0; _x < SCREEN_X_MAX; _x++)
	{
		x = _x + Origin.x;
		y = _y + Origin.y;

/*		 
		if (!Map->Map[maFog][x+Pitch.x][y+Pitch.y]) 
			continue;
*/	
		GameSystem->DisplayObject(maTile  ,x,y,Map->Map[maTile  ][x+Pitch.x][y+Pitch.y],Pitch,0);
		GameSystem->DisplayObject(maObject,x,y,Map->Map[maObject][x+Pitch.x][y+Pitch.y],Pitch,0);
		GameSystem->DisplayObject(maPerson,x,y,Map->Map[maPerson][x+Pitch.x][y+Pitch.y],Pitch,Map->Map[maObject][x+Pitch.x][y+Pitch.y]);
		GameSystem->DisplayObject(maField ,x,y,Map->Map[maField ][x+Pitch.x][y+Pitch.y],Pitch,GameSystem->FlippingCount & 0x1);

		value = Map->Map[maTile][x+Pitch.x][y+Pitch.y];
		if (Map->IsForegroundTile(value))
		{
			GameSystem->DisplayObject(maTile  ,x,y,Map->Map[maTile  ][x+Pitch.x][y+Pitch.y],Pitch,0);
		}
		value = Map->Map[maObject][x+Pitch.x][y+Pitch.y];
		if (IS_FOREGROUND_OBJECT_TILE(value))
		{
			GameSystem->DisplayObject(maObject,x,y,Map->Map[maObject][x+Pitch.x][y+Pitch.y],Pitch,0);
		}
	}
}

void CMain::FlipPage()
{
	LPDIRECTDRAWSURFACE	lpFrontBuffer = DDGetFrontBuffer();
	LPDIRECTDRAWSURFACE lpBackBuffer  = DDGetBackBuffer();
	char szTemp[256];

	GameSystem->FlippingCount++;
	if (GetTickCount() != GameSystem->StartTickCount) 
	GameSystem->FlipPerSecond = (float)(GameSystem->FlippingCount*1000) / (GetTickCount()-GameSystem->StartTickCount);

	sprintf(szTemp,"FPS : %4.2f",GameSystem->FlipPerSecond);
	GameSystem->HangulTransparency = FALSE;
	GameSystem->SetHangulColor(RGB(0,0,0));
	GameSystem->PrintHangul(0,0,szTemp);
	GameSystem->HangulTransparency = TRUE;
	GameSystem->SetHangulColor(RGB(250,255,200));
	GameSystem->PrintHangul(100,0,"ѱ  ׽Ʈ, , ˪۪");

	DDFlip();
}

void CMain::PreProcessing()
{
	TEventData	EventData;

	if (Application.KeyCode > 0)
	{
		switch(Application.KeyCode)
		{
			case VK_LEFT  : 
			case VK_RIGHT :
			case VK_UP    :
			case VK_DOWN  :
				EventData.Type	= _ET_MOVE;
				EventData.ID	= 0;
				switch(Application.KeyCode)
				{
					case VK_LEFT  : 
						EventData.Pos	= Point(-1,0);
						break;
					case VK_RIGHT :
						EventData.Pos	= Point(1,0);
						break;
					case VK_UP    :
						EventData.Pos	= Point(0,-1);
						break;
					case VK_DOWN  :
						EventData.Pos	= Point(0,1);
						break;
				}
				GameSystem->SendEvent(Main->Person[GameSystem->MAIN_CHARACTER],&EventData);
				break;
		}
		Application.KeyCode = 0;
	}

	for (int i = 1; i <= MAX_PERSON; i++)
	{
		if (i != GameSystem->MAIN_CHARACTER)
		if (Person[i])
		if (Random(100) == 0)
		{
			EventData.Type = _ET_MOVE;
			EventData.ID = 0;
			switch (Random(4))
			{
				case 0 : 
					EventData.Pos = Point(-1,0);
					break;
				case 1 : 
					EventData.Pos = Point(1,0);
					break;
				case 2 : 
					EventData.Pos = Point(0,-1);
					break;
				case 3 : 
					EventData.Pos = Point(0,1);
					break;
			}
			GameSystem->SendEvent(Person[i],&EventData);
		}
	}

}

void CMain::DoAction()
{
	int i;
	POINT pos;
	LPDIRECTDRAWSURFACE lpBackBuffer  = DDGetBackBuffer();

	// ȭ Clear
	FillBufferRect(lpBackBuffer,NULL,RGB(0,0,0));

	PreProcessing();

	for (i = 1; i <= MAX_PERSON; i++)
	{
		if (Person[i])
			Person[i]->DoAction();
	}

	// ȭ鿡 Fog 
//	Map->SetFog(Person[GameSystem->MAIN_CHARACTER]->mX,Person[GameSystem->MAIN_CHARACTER]->mY);

	DrawScreen();

	GetCursorPosEx(&pos);
	GameSystem->PutSprite(pos.x,pos.y,2,Bounds(18*25+1,7*25+1,24,24),smLeftTop);
//	GameSystem->PutSprite(pos.x,pos.y,2,Bounds(19*25+1,7*25+1,24,24),smLeftTop);
//	GameSystem->PutSprite(pos.x,pos.y,2,Bounds(20*25+1,7*25+1,24,24),smLeftTop);

	FlipPage();
}

void InitilizeMain()
{
	srand((unsigned int)time(NULL));
	Main = new CMain();
	Main->Initialize();
}

void FinalizeMain()
{
	delete Main;
}

void MainProc()
{
	Main->DoAction();
}
