
#include "UMap.h"


CMap::CMap()
{
	ForegroundTile = ftTown;
	MapSize = Point(0,0);
	memset(FMapName,0,sizeof(FMapName));
	memset(FBuffer ,0,sizeof(FBuffer ));
}

CMap::CMap(char *FileName)
{
	CMap();
	LoadFromFile(FileName);
}

CMap::~CMap()
{
	for (int MA = 0; MA < MAX_TMapAttribute; MA++)
	{
		if (FBuffer[MA])
		{
			free(FBuffer[MA]);
		}
		FBuffer[MA] = NULL;
	}
}

BYTE CMap::GetMap(TMapAttribute MapAttribute, INT32 x, INT32 y)
{
	if (InRange(x,0,MapSize.x-1) && InRange(y,0,MapSize.y-1)) 
		return FBuffer[MapAttribute][y * MapSize.x + x];
	else
		return 0;
}

void CMap::SetMap(TMapAttribute MapAttribute, INT32 x, INT32 y, BYTE Value)
{
	if (InRange(x,0,MapSize.x-1) && InRange(y,0,MapSize.y-1)) 
		FBuffer[MapAttribute][y * MapSize.x + x] = Value;
}

BOOL  CMap::GetEventMap(TMapEvent MapEvent, INT32 x, INT32 y)
{
	if (InRange(x,0,MapSize.x-1) && InRange(y,0,MapSize.y-1)) 
		return (Map[maAttribute][x][y] & (1 << MapEvent)) > 0;
	else
		return FALSE;
}

void CMap::SetEventMap(TMapEvent MapEvent, INT32 x, INT32 y)
{
	if (InRange(x,0,MapSize.x-1) && InRange(y,0,MapSize.y-1)) 
		Map[maAttribute][x][y] |= (1 << MapEvent);
}

BOOL CMap::IsMoveableMap(short x, short y)
{
	if (InRange(x,0,MapSize.x-1) && InRange(y,0,MapSize.y-1)) 
	if ( ((Map[maAttribute][x][y] & __WALKABLE_BIT) == 0) &&
		IS_MOVABLE_OBJECT_TILE(Map[maObject][x][y]) &&
		(Map[maPerson][x][y] == 0) )
		return TRUE;

	return FALSE;
}

BOOL CMap::IsMoveableMap4Fog(short x, short y)
{
	if (InRange(x,0,MapSize.x-1) && InRange(y,0,MapSize.y-1)) 
	{
		BYTE tile = Map[maTile][x][y];
		if (
			((IS_MOVABLE_TILE(tile) || IsForegroundTile(tile) || InRange(tile,92,95)) && 
			(!((tile == 105) || (tile == 107) || (tile == 125) || (tile == 127)))) ||
			((tile == 105) || (tile == 125)) && ((Map[maAttribute][x][y] & __WALKABLE_BIT) == 0)
			)
		{
			return TRUE;
		}
	}

	return FALSE;

}

BOOL CMap::IsForegroundTile(BYTE tile)
{
	switch (ForegroundTile)
	{
		case ftTown :
			return IS_FOREGROUND_TILE_TOWN(tile);
		case ftDen  :
			return IS_FOREGROUND_TILE_DEN(tile);
	}
	return FALSE;
}

BOOL CMap::IsWallTile(BYTE tile)
{
	switch (ForegroundTile)
	{
		case ftTown :
			return IS_WALL_TILE_TOWN(tile);
		case ftDen  :
			return IS_WALL_TILE_DEN(tile);
	}
	return FALSE;
}

BOOL CMap::LoadFromFile(char *FileName)
{
	FILE *fp;
	WORD x, y;
	int MA;

	ForegroundTile = ftTown;

	if ((fp = fopen(FileName,"rb")) == NULL)
		return FALSE;

	strcpy(FMapName,FileName);

	fread(&x,1,2,fp); fread(&x,1,2,fp); // Gabage Reading

	fread(&x,1,2,fp);
	fread(&y,1,2,fp);

	MapSize = Point(x,y);

	for (MA = 0; MA < maPerson; MA++)
	{
		FBuffer[MA] = (BYTE *)malloc(x * y);
		fread(FBuffer[MA],1,x * y,fp);
	}

	fclose(fp);

	for (MA = maPerson; MA < MAX_TMapAttribute; MA++)
	{
		FBuffer[MA] = (BYTE *)malloc(x * y);
		memset(FBuffer[MA],0,x * y);
	}

	return TRUE;
}

BOOL CMap::SaveToFile(char *FileName)
{
	return TRUE;
}

void CMap::MakeRandomMap()
{
	for (int y = 0; y < MapSize.y; y++)
	{
		for (int x = 0; x < MapSize.x; x++)
		{
			if ((rand() % 3) == 0)
			{
				Map[maTile][x][y] = 1;
			}
			else
			{
				Map[maTile][x][y] = 0;
			}
		}
	}
}

#define PUT(x,y) \
					if (((x) >= 0) && ((x) < Succ(VIEW_WIDE_X*2)) && ((y) >= 0) && ((y) < Succ(VIEW_WIDE_Y*2))) \
					if (!Buffer[x][y]) \
					{ \
						Buffer[x][y] = 255; \
						Changed = TRUE; \
					} \
					else \
					{ \
						if (Buffer[x][y] != 255) \
						{ \
							Buffer[x][y] = 2; \
						} \
					} \

/*
							if ((y-1) >= 0) \
							{ \
								if (IsForegroundTile(Map[maTile][(x)+_x-VIEW_WIDE_X][(y-1)+_y-VIEW_WIDE_Y])) \
								{ \
									Buffer[x][y-1] = 2; \
								} \
							} \
							if ((y+1) < Succ(VIEW_WIDE_Y*2)) \
							{ \
								if (IsForegroundTile(Map[maTile][(x)+_x-VIEW_WIDE_X][(y+1)+_y-VIEW_WIDE_Y])) \
								{ \
									Buffer[x][y+1] = 2; \
								} \
							} \
*/


void CMap::SetFog(int _x, int _y)
{
	int  i, j;
	BYTE tile1, tile2;
	BOOL Changed;

	BYTE Buffer[Succ(VIEW_WIDE_X*2)][Succ(VIEW_WIDE_Y*2)];
	memset(Buffer,0,Succ(VIEW_WIDE_X*2) * Succ(VIEW_WIDE_Y*2));

	for (j = 0; j <= VIEW_WIDE_Y*2; j++)
	{
		for (i = 0; i <= VIEW_WIDE_X*2; i++)
		{
			Buffer[i][j] = IsMoveableMap4Fog(_x+i-VIEW_WIDE_X,_y+j-VIEW_WIDE_Y) ? 0 : 1;
		}
	}

	Buffer[VIEW_WIDE_X][VIEW_WIDE_Y] = 255;

	Changed = TRUE;
	while (Changed)
	{
		Changed = FALSE;
		for (j = 0; j <= VIEW_WIDE_Y*2; j++)
		{
			for (i = 0; i <= VIEW_WIDE_X*2; i++)
			{
				if (Buffer[i][j] == 255)
				{
					Buffer[i][j] = 2; // Found !
					PUT(i+1,j+0)
					PUT(i-1,j+0)
					PUT(i+0,j+1)
					PUT(i+0,j-1)
					PUT(i+1,j+1)
					PUT(i-1,j-1)
					PUT(i-1,j+1)
					PUT(i+1,j-1)
				}
			}
		}
	}

	for (j = 1; j < VIEW_WIDE_Y*2; j++)
	{
		for (i = 0; i <= VIEW_WIDE_X*2; i++)
		{
			if ((Buffer[i][j] == 0) && (Buffer[i][j-1] == 2))
			{
				tile2 = Map[maTile][_x+i-VIEW_WIDE_X][_y+j-VIEW_WIDE_Y-1];
				if (IsForegroundTile(tile2))
					Buffer[i][j] = 2;
			}
			if (Buffer[i][j] == 2)
			{
				tile1 = Map[maTile][_x+i-VIEW_WIDE_X][_y+j-VIEW_WIDE_Y];
				tile2 = Map[maTile][_x+i-VIEW_WIDE_X][_y+j-VIEW_WIDE_Y-1];
				if (IsWallTile(tile1) || IsForegroundTile(tile2) || (tile2 == 105) || (tile2 == 125))
					Buffer[i][j-1] = 2;
			}
		}
	}

	memset(FBuffer[maFog],0,MapSize.x * MapSize.y);
	for (j = -VIEW_WIDE_Y; j <= VIEW_WIDE_Y; j++)
	{
		for (i = -VIEW_WIDE_X; i <= VIEW_WIDE_X; i++)
		{
			Map[maFog][_x+i][_y+j] = (Buffer[i+VIEW_WIDE_X][j+VIEW_WIDE_Y] == 2) ? 1 : 0;
		}
	}

}
