
#ifndef __UMAP_H

#define __UMAP_H

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "UTypes.h"

typedef enum 
{
	ftTown, 
	ftDen
} TForegroundTile;

class CMap 
{

	public:

		CMap();
		CMap(char *FileName);

		~CMap();

	private:

		char FMapName[16];
		BYTE *FBuffer[MAX_TMapAttribute];

	public:

		POINT MapSize;
		TForegroundTile ForegroundTile;

		BYTE GetMap(TMapAttribute MapAttr, INT32 x, INT32 y);
		void SetMap(TMapAttribute MapAttr, INT32 x, INT32 y, BYTE Value);
		BOOL GetEventMap(TMapEvent MapEvent, INT32 x, INT32 y);
		void SetEventMap(TMapEvent MapEvent, INT32 x, INT32 y);

		BOOL IsMoveableMap(short x, short y);
		BOOL IsMoveableMap4Fog(short x, short y);
		BOOL IsForegroundTile(BYTE tile);
		BOOL IsWallTile(BYTE tile);
		BOOL LoadFromFile(char *FileName);
		BOOL SaveToFile(char *FileName);

		void MakeRandomMap();
		void SetFog(int x, int y);

		__declspec(property(get=GetMap,      put=SetMap      )) BYTE  Map[];
		__declspec(property(get=GetEventMap, put=SetEventMap )) BYTE  EventMap[];
};


#endif
