
#include <windows.h>

#include "USys.h"
#include "UPerson.h"
#include "UMain.h"

extern CMain *Main;
extern CGameSystem *GameSystem;


/* Start of CCharacter */

CCharacter::CCharacter(short Number, short x, short y, short Job, TFaceDirection Face,
					TMagicNeed PersonAttribute, TMapAttribute FaceAttribute, BYTE MaxFrame)
{
	mNumber          = Number;
	mJob             = Job;
	mFace            = Face;
	mFaceCount       = 0;
	mTransparency    = 100;

	mFaceIncSub      = 0;
	mInMoving        = FALSE;
	mMoveStep        = 0;
	mMoveDir         = Point(0,0);

	mPersonAttribute = PersonAttribute;
	mFaceAttribute   = FaceAttribute;
	mMaxFrame        = MaxFrame;

	WarpXY(x,y);
}

CCharacter::~CCharacter()
{
}

void   CCharacter::DoAction()
{
	TEventData EventData;

	if (mInMoving)
	{
		MoveXYAuto();
		return;
	}

	if (this->PopEvent(&EventData))
	{
		switch (EventData.Type)
		{
			case _ET_MOVE :
				MoveXY((short)EventData.Param1,(short)EventData.Param2);
				break;
		}
		
	}
}

void   CCharacter::SetFace(POINT Direction)
{
	if (Direction.y < 0) mFace = fdUp;
	if (Direction.y > 0) mFace = fdDown;
	if (Direction.x < 0) mFace = fdLeft;
	if (Direction.x > 0) mFace = fdRight;
}

void   CCharacter::IncFaceStep()
{
	mFaceIncSub++;

	if (mFaceIncSub >= MAX_FACE_COUNT_SUB)
	{
		mFaceCount += mFaceInc;
		if (mFaceInc > 0)
		{
			if (mFaceCount >= PERSON_FRAME)
				mFaceCount = 0;
		} 
		else 
		{
			if (mFaceCount < 0)
				mFaceCount = Pred(PERSON_FRAME);
		}
		mFaceIncSub = 0;
	}
}

short  CCharacter::GetImageNumber()
{
	short i = 0;

	if (mMaxFrame == 8)
	{
		switch (mFace) 
		{
			case fdUp    : 
				i = 6;
				break;
			case fdDown  : 
				i = 0;
				break;
			case fdLeft  : 
				i = 2;
				break;
			case fdRight : 
				i = 4;
				break;
			default      :
				i = 0;
				break;
		}
		i = Pred(mJob) * PERSON_ARRANGE + i + mFaceCount;
	}

	return i;
}

void   CCharacter::WarpXY(short x, short y)
{

    if (Main)
	{
		if (Main->Map)
		{
			if (InRange(x,0,Pred(Main->Map->MapSize.x)) &&
				InRange(y,0,Pred(Main->Map->MapSize.y)))
			{
				Main->Map->Map[maPerson][mX][mY] = 0;
				mX = x;
				mY = y;
				Main->Map->Map[maPerson][x][y] = (BYTE)mNumber;
			}
		}
	}

}

void   CCharacter::MoveXY(short x1, short y1)
{
	short x, y;

	if (mInMoving) 
		return;

	mMoveDir = Point(0,0);

	if (Main)
	{
		if (Main->Map)
		{
			if (Main->Map->IsMoveableMap(mX + x1,mY + y1))
			{
				mFaceCount = mFaceCount ^ 1;
				x = mX + x1;
				y = mY + y1;
				WarpXY(x,y);
			}

			if ((mMoveDir.x != 0) || (mMoveDir.y != 0))
			{
				SetFace(mMoveDir);
				Main->Map->Map[maPerson][mX+mMoveDir.x][mY+mMoveDir.y] = mNumber + 100;
				mMoveStep = 0;
				mInMoving = TRUE;
				MoveXYAuto();
			}
			else 
			{
				SetFace(Point(x1,y1));
			}
		}
	}

}

void   CCharacter::MoveXYAuto()
{
	if (!mInMoving)
		return;

	mMoveStep++;
	IncFaceStep();

	if (mMoveStep >= WALK_FRAME)
	{
		Main->Map->Map[maPerson][mX][mY] = 0;
		mX        += (short)mMoveDir.x;
		mY        += (short)mMoveDir.y;
		Main->Map->Map[maPerson][mX][mY] = (BYTE)mNumber;
		mInMoving = FALSE;
		mMoveDir  = Point(0,0);
   }

}

/* End of CCharacter */

/* Start of CPerson */

long	CPerson::GetAbility(TAbility element)
{
	if (InRange(element,0,Pred(MAX_TAbility)))
	{
		return mAbility[element];
	}
	return 0;
}

void	CPerson::SetAbility(TAbility element, long value)
{
	if (InRange(element,0,Pred(MAX_TAbility)))
	{
		mAbility[element] = value;
	}
}

long	CPerson::GetInternal(TInternal element)
{
	if (InRange(element,0,Pred(MAX_TInternal)))
	{
		return mInternal[element];
	}
	return 0;
}

void	CPerson::SetInternal(TInternal element, long value)
{
	if (InRange(element,0,Pred(MAX_TInternal)))
	{
		mInternal[element] = value;
	}
}

/* End of CPerson */
