
#ifndef __UPERSON_H

#define __UPERSON_H

#include "UTypes.h"
#include "USys.h"

static INT32 MAX_FACE_COUNT_SUB = 1;
const  PERSON_FRAME = 2;
const  PERSON_DIRECTION = 4;
const  PERSON_ALL_FRAME = PERSON_FRAME * PERSON_DIRECTION;
static INT32 WALK_FRAME = 2; //MAX_FACE_COUNT_SUB * PERSON_FRAME;

class CCharacter : public CEventQueue
{
/*
      constructor init(number, face : integer; person_attribute : magic_need_T;
                  face_attribute : map_attribute_T; name : string;
                  max_frame : byte; initialize_position : boolean);
*/
	public:

		CCharacter(	short Number, short x, short y, short Job, TFaceDirection Face,
					TMagicNeed PersonAttribute, TMapAttribute FaceAttribute, BYTE MaxFrame);
		~CCharacter();

		void DoAction();

		INT32	mFaceIncSub;
		BOOL	mInMoving;
		INT32	mMoveStep;
		POINT	mMoveDir;

		short	mNumber;
		short	mJob;
		short	mX;
		short	mY;
		short	mFaceCount;
		short	mFaceInc;
		BYTE    mTransparency;

		TFaceDirection	mFace;
		TMagicNeed		mPersonAttribute;
		TMapAttribute	mFaceAttribute;
		BYTE			mMaxFrame;

		void	SetFace(POINT Direction);
		void	IncFaceStep();
		short	GetImageNumber();
		void	WarpXY(short x, short y);
		void	MoveXY(short x1, short y1);
		void	MoveXYAuto();
};

class CPerson : public CCharacter
{
	public:

		long	mAbility[MAX_TAbility];
		long	mInternal[MAX_TInternal];

		long	GetAbility(TAbility element);
		void	SetAbility(TAbility element, long value);

		long	GetInternal(TInternal element);
		void	SetInternal(TInternal element, long value);

		__declspec(property(get=GetAbility,  put=SetAbility )) long Ability;
		__declspec(property(get=GetInternal, put=SetInternal)) long Internal;
};

#endif