
#include <windows.h>
#include <stdio.h>
#include <math.h>
#include "URotate.h"

#define Sine_Cosine_Precision	128
#define ADDR(ptr,a)				(BYTE *)((long)(ptr) + (long)(a))


CRotate::CRotate(const char *FileName)
{
	Canvas       = NULL;
	CanvasSize.x = SOURCE_X_WIDE;
	CanvasSize.y = SOURCE_Y_WIDE;
	BPP          = 1;
	CanvasBytes  = CanvasSize.x * CanvasSize.y * BPP;

	InitializeRotation(FileName);
}

CRotate::~CRotate()
{
	FinalizeRotation();
}

void CRotate::PutPixel (int X, int Y, BYTE Col)
{
	if ((X >= 0) && (X < SOURCE_X_WIDE) &&
		(Y >= 0) && (Y < SOURCE_Y_WIDE)) 
	{
		long ptr = (long)Y*SOURCE_X_WIDE+X;
		*ADDR(Canvas,ptr) = Col;
	}   
};

void CRotate::SwapInt(short &i1, short &i2)
{
	short dummy;

	dummy = i2;
	i2    = i1;
	i1    = dummy;
};

void CRotate::CopyLine(void *Buf, short W, short x1, short y1, short x2, short y2)
{
	short d, dx, dy, aincr, bincr,	xincr, yincr, x, y;
	short BitMap_Pos;
	short BitMap_Dir;
	short BitMap_Dif;

	if ( abs(x2-x1) < abs(y2-y1) ) 
	{
		BitMap_Dif = abs(x2-x1)+abs(y2-y1);

		if ( y1 > y2 ) 
		{
			SwapInt( x1, x2 );
			SwapInt( y1, y2 );
			BitMap_Dir = -1;
			BitMap_Pos = BitMap_Dif;
		}
		else 
		{
			BitMap_Dir = 1;
			BitMap_Pos = 0;
		};

		if ( x2 > x1 ) 
			xincr = 1;
		else
			xincr = -1;

		dy = y2 - y1;
		dx = abs( x2-x1 );
		d  = 2 * dx - dy;
		aincr = 2 * (dx - dy);
		bincr = 2 * dx;
		x = x1;
		y = y1;

		PutPixel ( x,y, *ADDR(Buf,(BitMap_Pos * W) / BitMap_Dif));

		for (y = y1+1; y <= y2; y++) // Execute line on Y-axes 
		{                   
			if ( d >= 0 ) 
			{
				BitMap_Pos += BitMap_Dir;
				PutPixel ( x,y, *ADDR(Buf,(BitMap_Pos * W) / BitMap_Dif));
				x += xincr;
				d += aincr;
			}
			else 
			{
				d += bincr;
			}

			BitMap_Pos += BitMap_Dir;
			PutPixel ( x,y, *ADDR(Buf,(BitMap_Pos * W) / BitMap_Dif));
		}
	}
	else // Check X-axes 
	{
		BitMap_Dif = abs(x2-x1)+abs(y2-y1);
		if ( x1 > x2 ) 
		{						// x1 > x2?
			SwapInt( x1, x2 );	// Yes --> Swap x1 with x2
			SwapInt( y1, y2 );	//         and  y1 with y2
			BitMap_Dir = -1;
			BitMap_Pos = BitMap_Dif;
		}
		else 
		{
			BitMap_Dir = 1;
			BitMap_Pos = 0;
		}

		if ( y2 > y1 )
			yincr = 1;  // Set Y-axis increment
		else 
			yincr = -1;

		dx = x2 - x1;
		dy = abs( y2-y1 );
		d  = 2 * dy - dx;
		aincr = 2 * (dy - dx);
		bincr = 2 * dy;
		x = x1;
		y = y1;

		PutPixel ( x,y, *ADDR(Buf,(BitMap_Pos * W) / BitMap_Dif));

		for (x = x1+1; x <= x2; x++) // Execute line on X-axes
		{                
			if ( d >= 0 ) 
			{
				BitMap_Pos += BitMap_Dir;
				PutPixel ( x,y, *ADDR(Buf,(BitMap_Pos * W) / BitMap_Dif));
				y += yincr;
				d += aincr;
			}
			else 
			{
				d += bincr;
			}
			BitMap_Pos += BitMap_Dir;
			PutPixel ( x,y, *ADDR(Buf,(BitMap_Pos * W) / BitMap_Dif));
		}
	}
}

void CRotate::Rotate(void *Buf, short OldW, short OldH, short W, short H, short X, short Y, short Angle)
{
	short X1,Y1,X2,Y2,X3,Y3;
	short HalfH,HalfW;
	short DeltaX,DeltaY;
	short TY;
/*
  P1(X1,Y1)           P2(X2,Y2)
	#                   #



  	#                   #
  P3(X3,Y3)           P4(X4,Y4)

*/
	HalfH = H >> 1;
	HalfW = W >> 1;
	X1 = X+((-HalfW*Cosine[Angle])-(+HalfH*Sine[Angle])) / Sine_Cosine_Precision;
	X2 = X+((+HalfW*Cosine[Angle])-(+HalfH*Sine[Angle])) / Sine_Cosine_Precision;
	X3 = X+((-HalfW*Cosine[Angle])-(-HalfH*Sine[Angle])) / Sine_Cosine_Precision;

	Y1 = Y+((-HalfW*Sine[Angle])+(+HalfH*Cosine[Angle])) / Sine_Cosine_Precision;
	Y2 = Y+((+HalfW*Sine[Angle])+(+HalfH*Cosine[Angle])) / Sine_Cosine_Precision;
	Y3 = Y+((-HalfW*Sine[Angle])+(-HalfH*Cosine[Angle])) / Sine_Cosine_Precision;

	DeltaY = Y3-Y1;
	DeltaX = X3-X1;
									/*              # P1(X1,Y1)       */
	for (TY = 0; TY < H; TY++) {	/*            /                   */
									/*          /                     */
									/*        /                       */
		X = DeltaX*TY / H;			/*      # P3(X3,Y3)               */
		Y = DeltaY*TY / H;			/*   SubX = DeltaX*TY / H         */
									/*   SubY = DeltaY*TY / H         */
		CopyLine ( ADDR(Buf,(TY*OldH / H)*OldW),OldW,X2+X,Y2+Y,X1+X,Y1+Y);
	}
}

void CRotate::MakeSineCosineTable()
{
	for (int I = 0; I < 360; I++) {
		Sine[I]   = (short)(sin(I*3.14159265/180)*Sine_Cosine_Precision);
		Cosine[I] = (short)(cos(I*3.14159265/180)*Sine_Cosine_Precision);
   }	
}

void CRotate::InitializeRotation(const char *FileName)
{
	WORD wTemp;

	if ((F = fopen(FileName,"rb")) == NULL)
		return;

	fread(&wTemp,2,1,F);
	BitMapSize.x = wTemp;

	fread(&wTemp,2,1,F);
	BitMapSize.y = wTemp;

	fread(&RGB,MAX_PALETTE*3,1,F);

	BitMap = malloc(BitMapSize.x * BitMapSize.y);
	fread(BitMap,BitMapSize.x * BitMapSize.y,1,F);
	fclose(F);

	MakeSineCosineTable();

	for (int i = 0; i < MAX_PALETTE; i++) {

		RGB[i*3+0] <<= 2;
		RGB[i*3+1] <<= 2;
		RGB[i*3+2] <<= 2;

		RGB16[i] = ((WORD)(RGB[i*3+0] & 0xF8) << 8) |
					((WORD)(RGB[i*3+1] & 0xFC) << 3) |
					((WORD)(RGB[i*3+2] & 0xF8) >> 3); 
	}

	Canvas = malloc(CanvasBytes);
}

void CRotate::FinalizeRotation()
{
	free(Canvas);
}

void CRotate::ProcessRotation(short Angle, short Size)
{
//	memset(Canvas,0,CanvasBytes);
	memset(Canvas,255,CanvasBytes);

	Rotate (BitMap,BitMapSize.x,BitMapSize.y,
			BitMapSize.x*Size / 100, BitMapSize.y*Size / 100,
			160,100,Angle );
}

void CRotate::DisplayRotationDC(HDC DC)
{
	struct TBitMapInfo 
	{
		BITMAPINFOHEADER bmiHeader;
		RGBQUAD          bmiColors[MAX_PALETTE];
	} BitmapInfo;

	ZeroMemory(&BitmapInfo,sizeof(BitmapInfo));

	// DIB  մϴ.

	//  ũ
	BitmapInfo.bmiHeader.biSize        = sizeof(BitmapInfo.bmiHeader);
	//  DIB   ũ
	BitmapInfo.bmiHeader.biWidth       = SOURCE_X_WIDE;
	//  DIB   ũ
	BitmapInfo.bmiHeader.biHeight      = SOURCE_Y_WIDE;
	//  DIB  ÷μ, 256 ÷ 1.
	BitmapInfo.bmiHeader.biPlanes      = 1;
	//  DIB  ȼbit, 8 ̸ 8bit ÷,  256 ÷
	BitmapInfo.bmiHeader.biBitCount    = 8;
	// DIB RGB  Ǿ ִ.
	BitmapInfo.bmiHeader.biCompression = BI_RGB;
	// DIB ޸ ũ
	BitmapInfo.bmiHeader.biSizeImage   = SOURCE_X_WIDE*SOURCE_Y_WIDE;

	for (int i = 0; i < MAX_PALETTE; i++) {
		// 256  ȷƮ ԷѴ.
		BitmapInfo.bmiColors[i].rgbRed   = RGB[i*3+0];
		BitmapInfo.bmiColors[i].rgbGreen = RGB[i*3+1];
		BitmapInfo.bmiColors[i].rgbBlue  = RGB[i*3+2];
	}

	BitmapInfo.bmiColors[255].rgbRed   = 55;
	BitmapInfo.bmiColors[255].rgbGreen = 55;
	BitmapInfo.bmiColors[255].rgbBlue  = 255;

	//  DIB Լ, Ʒ ٽ Ѵ.
	SetDIBitsToDevice(DC,0,0,SOURCE_X_WIDE,SOURCE_Y_WIDE,0,0,0,SOURCE_Y_WIDE,
						Canvas,(tagBITMAPINFO *)&BitmapInfo,DIB_RGB_COLORS);

}

void CRotate::DisplayRotationDX(IDirectDrawSurface *lpDDrawBuffer, int DestX, int DestY)
{
	DDSURFACEDESC		SurfaceDesc;
	WORD                *ScreenPtr;
	BYTE				*CanvasPtr;
	HRESULT             Result;

	SurfaceDesc.dwSize = sizeof(SurfaceDesc);
    while ((Result = lpDDrawBuffer->Lock(NULL, &SurfaceDesc, 0, NULL)) == DDERR_WASSTILLDRAWING);

    if (Result == DD_OK)
	{
		// Direct X   ׷ ī  
		for (int y = 0; y < CanvasSize.y; y++)
		{
			ScreenPtr = (WORD *)((DWORD)SurfaceDesc.lpSurface + SurfaceDesc.lPitch * (y+DestY) + DestX * 2);
			CanvasPtr = (BYTE *)((DWORD)Canvas + CanvasSize.x * (CanvasSize.y-y-1));
			for (int x = 0; x < CanvasSize.x; x++)
			{
				if (*CanvasPtr != 255) {
					*ScreenPtr = RGB16[*CanvasPtr];
				}
				ScreenPtr++;
				CanvasPtr++;
			}
		}

		lpDDrawBuffer->Unlock(NULL);
	}
}
