
#ifndef __UROTATE_H

#define __UROTATE_H

#include <DDraw.h>

#define SOURCE_X_WIDE			320
#define SOURCE_Y_WIDE			200
#define MAX_PALETTE				256

class CRotate
{

	public:

		CRotate(const char *FileName);
		~CRotate();

	private:

		short Cosine[360], Sine[360];
		FILE  *F;
		void  *BitMap;
		POINT BitMapSize;

		void PutPixel (int X, int Y, BYTE Col);
		void SwapInt(short &i1, short &i2);
		void CopyLine(void *Buf, short W, short x1, short y1, short x2, short y2);
		void Rotate (void *Buf, short OldW, short OldH, short W, short H, short X, short Y, short Angle);
		void MakeSineCosineTable();

	public:

		void  *Canvas;
		POINT CanvasSize;
		BYTE  BPP;
		INT32 CanvasBytes;

		BYTE  RGB[MAX_PALETTE*3];
		WORD  RGB16[MAX_PALETTE];

		void InitializeRotation(const char *FileName);
		void FinalizeRotation();
		void ProcessRotation(short Angle, short Size);
		void DisplayRotationDC(HDC DC);
		void DisplayRotationDX(IDirectDrawSurface *lpDDrawBuffer, int DestX, int DestY);
};

#endif

