

#include <windows.h>
#include <ddraw.h>
#include "DDrawEx.h"
#include "Rogue.h"
#include "USys.h"
#include "UMain.h"

extern TApplication Application;
extern CMain *Main;

long _ABS_X = 0;
long _ABS_Y = 0;
/* Start of CGameSystem */

CGameSystem::CGameSystem()
{
	MAIN_CHARACTER	= 1;
	FlippingCount	= 0;
	StartTickCount	= 0;
	FlipPerSecond	= 0.0;

	HangulColor		= RGB(255,255,255);
	HangulFont		= CreateFont(16,0,0,0,FW_THIN/*FW_BLACK*/,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_CHARACTER_PRECIS,
								CLIP_CHARACTER_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,"ü");
}

CGameSystem::~CGameSystem()
{
	DeleteObject(HangulFont);
}

void CGameSystem::ModifyClip(int &x, int &y, RECT &ARect, TSpriteMode mode)
{
	if (mode == smCentered)
	{
		x -= Succ(ARect.right - ARect.left) / 2;
		y -= (ARect.bottom - ARect.top);
	}

	if (x < 0)
	{
		ARect.left -= x;
		x = 0;
	}
	if (y < 0)
	{
		ARect.top -= y;
		y = 0;
	}
	if ((x + ARect.right - ARect.left) > Pred(MAX_X_LINE))
	{
		ARect.right = MAX_X_LINE + ARect.left - x;
	}
	if ((y + ARect.bottom - ARect.top) > Pred(MAX_Y_LINE))
	{
		ARect.bottom = MAX_Y_LINE + ARect.top - y;
	}
}

void CGameSystem::PutTile(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode)
{
	LPDIRECTDRAWSURFACE lpBackBuffer  = DDGetBackBuffer();
	LPDIRECTDRAWSURFACE lpImageBuffer = DDGetImageBuffer(ImageNumber);

	ModifyClip(x,y,ARect,mode);

	do
	{
	} while (!MakeItSo(lpBackBuffer->BltFast(x,y,lpImageBuffer,&ARect,DDBLTFAST_NOCOLORKEY)));

}

void CGameSystem::PutSprite(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode)
{
	LPDIRECTDRAWSURFACE lpBackBuffer  = DDGetBackBuffer();
	LPDIRECTDRAWSURFACE lpImageBuffer = DDGetImageBuffer(ImageNumber);

	ModifyClip(x,y,ARect,mode);

	do
	{
	} while (!MakeItSo(lpBackBuffer->BltFast(x,y,lpImageBuffer,&ARect,DDBLTFAST_SRCCOLORKEY)));

}

void CGameSystem::PutSpriteExHalf(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode)
{
	LPDIRECTDRAWSURFACE lpBackBuffer  = DDGetBackBuffer();
	LPDIRECTDRAWSURFACE lpImageBuffer = DDGetImageBuffer(ImageNumber);
	DDSURFACEDESC		SourDesc;
	DDSURFACEDESC		DestDesc;
	HRESULT             SourResult;
	HRESULT             DestResult;
	WORD				*Sour, *Dest;
	WORD                MASK_WORD = 0xF7DE;

	ModifyClip(x,y,ARect,mode);

	ZeroMemory(&SourDesc,sizeof(SourDesc));
	ZeroMemory(&DestDesc,sizeof(DestDesc));

	SourDesc.dwSize = sizeof(SourDesc);
	DestDesc.dwSize = sizeof(DestDesc);

    while ((SourResult = lpImageBuffer->Lock(NULL, &SourDesc, 0, NULL)) == DDERR_WASSTILLDRAWING);
    while ((DestResult = lpBackBuffer->Lock(NULL, &DestDesc, 0, NULL)) == DDERR_WASSTILLDRAWING);

    if ((SourResult == DD_OK) && (DestResult == DD_OK))
    {
		for (int _y = 0; _y < (ARect.bottom - ARect.top); _y++)
		{
			Sour = (WORD *)((DWORD)SourDesc.lpSurface + SourDesc.lPitch * (ARect.top+_y) + (ARect.left) * 2);
			Dest = (WORD *)((DWORD)DestDesc.lpSurface + DestDesc.lPitch * (y+_y) + (x) * 2);
			for (int _x = 0; _x < (ARect.right - ARect.left); _x++)
			{
				if (*Sour)
					*Dest = (WORD)(((DWORD)(*Dest & MASK_WORD) + (DWORD)(*Sour & MASK_WORD)) >> 1);
				Sour++;
				Dest++;
			}
		}
    }

	if (SourResult == DD_OK)
		lpImageBuffer->Unlock(NULL);

	if (DestResult == DD_OK)
		lpBackBuffer->Unlock(NULL);
}

void CGameSystem::PutSpriteEx(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode, BYTE Transparency)
{

	// Ķ ó
	if (Transparency <= 0)
		return;

	if (Transparency >= 100)
	{
		PutSprite(x, y, ImageNumber, ARect, mode);
		return;
	}

	if (Transparency == 50)
	{
		PutSpriteExHalf(x, y, ImageNumber, ARect, mode);
		return;
	}

	//  
	LPDIRECTDRAWSURFACE lpBackBuffer  = DDGetBackBuffer();
	LPDIRECTDRAWSURFACE lpImageBuffer = DDGetImageBuffer(ImageNumber);
	DDSURFACEDESC		SourDesc;
	DDSURFACEDESC		DestDesc;
	HRESULT             SourResult;
	HRESULT             DestResult;
	WORD				*Sour, *Dest;
	DWORD				R1, G1, B1, R2, G2, B2;
	WORD                MASK_RED   = 0xF800;
	WORD                MASK_GREEN = 0x07E0;
	WORD                MASK_BLUE  = 0x001F;

	ModifyClip(x,y,ARect,mode);

	ZeroMemory(&SourDesc,sizeof(SourDesc));
	ZeroMemory(&DestDesc,sizeof(DestDesc));

	SourDesc.dwSize = sizeof(SourDesc);
	DestDesc.dwSize = sizeof(DestDesc);

    while ((SourResult = lpImageBuffer->Lock(NULL, &SourDesc, 0, NULL)) == DDERR_WASSTILLDRAWING);
    while ((DestResult = lpBackBuffer->Lock(NULL, &DestDesc, 0, NULL)) == DDERR_WASSTILLDRAWING);

    if ((SourResult == DD_OK) && (DestResult == DD_OK))
    {
		for (int _y = 0; _y < (ARect.bottom - ARect.top); _y++)
		{
			Sour = (WORD *)((DWORD)SourDesc.lpSurface + SourDesc.lPitch * (ARect.top+_y) + (ARect.left) * 2);
			Dest = (WORD *)((DWORD)DestDesc.lpSurface + DestDesc.lPitch * (y+_y) + (x) * 2);
			for (int _x = 0; _x < (ARect.right - ARect.left); _x++)
			{
				if (*Sour)
				{
					R1 = (*Sour & MASK_RED  ) * Transparency;
					G1 = (*Sour & MASK_GREEN) * Transparency;
					B1 = (*Sour & MASK_BLUE ) * Transparency;
					R2 = (*Dest & MASK_RED  ) * (100 - Transparency);
					G2 = (*Dest & MASK_GREEN) * (100 - Transparency);
					B2 = (*Dest & MASK_BLUE ) * (100 - Transparency);

					R1 = ((R1 + R2) / 100) & MASK_RED;
					G1 = ((G1 + G2) / 100) & MASK_GREEN;
					B1 = ((B1 + B2) / 100) & MASK_BLUE;

					R1 = R1 | G1 | B1;

					*Dest = (WORD)R1;
				}
				Sour++;
				Dest++;
			}
		}
    }

	if (SourResult == DD_OK)
		lpImageBuffer->Unlock(NULL);

	if (DestResult == DD_OK)
		lpBackBuffer->Unlock(NULL);
}

void CGameSystem::DisplayObject(TMapAttribute MA, int x, int y, short value, POINT APoint, short aux)
{
	RECT ARect;
	BYTE Transparency;

	switch (MA)
	{
		case maTile      : 
			ARect = Bounds((value % TILE_ARRANGE)*Succ(TILE_X_SIZE)+1,(value / TILE_ARRANGE)*Succ(TILE_X_SIZE)+1,TILE_X_SIZE,TILE_Y_SIZE);
			PutTile(x*TILE_X_SIZE+_ABS_X,y*TILE_Y_SIZE+_ABS_Y,1,ARect,smLeftTop);
			break;
		case maObject    :
			if (InRange(value,1,100))
			{
				ARect = Bounds((value % OBJECT_ARRANGE)*Succ(TILE_X_SIZE)+(9*Succ(TILE_X_SIZE)+1),(value / OBJECT_ARRANGE)*Succ(TILE_Y_SIZE)+(7*Succ(TILE_Y_SIZE)+1),TILE_X_SIZE,TILE_Y_SIZE);
				PutSprite(x*TILE_X_SIZE+_ABS_X,y*TILE_Y_SIZE+_ABS_Y,2,ARect,smLeftTop);
			}
			if (value > 100)
			{
				value -= 101;
				ARect = Bounds((value % EQUIP_ARRANGE)*Succ(TILE_X_SIZE)+(18*Succ(TILE_X_SIZE)+1),(value / EQUIP_ARRANGE)*Succ(TILE_Y_SIZE)+1,TILE_X_SIZE,TILE_Y_SIZE);
				PutSprite(x*TILE_X_SIZE+_ABS_X,y*TILE_Y_SIZE+_ABS_Y,2,ARect,smLeftTop);
			}
			break;
		case maField     : 
			if ((value > 0) && !((value == __FIELD_VACUUM) || (value == __FIELD_SLEEP)))
			{
				value += aux * 8;
				ARect = Bounds((value % FIELD_ARRANGE)*Succ(TILE_X_SIZE)+(9*Succ(TILE_X_SIZE)+1),(value / FIELD_ARRANGE)*Succ(TILE_Y_SIZE)+(13*Succ(TILE_Y_SIZE)+1),TILE_X_SIZE,TILE_Y_SIZE);
				PutSpriteEx(x*TILE_X_SIZE+_ABS_X,y*TILE_Y_SIZE-10+_ABS_Y,2,ARect,smLeftTop,80);
			}
			break;
		case maAttribute :
			break;
		case maPerson    :
			if (value > 0)  
			{
				Transparency = Main->Person[value]->mTransparency;
				if (aux != 2)
				{
					value = Main->Person[value]->GetImageNumber();
					ARect = Bounds((value % PERSON_ARRANGE)*Succ(TILE_X_SIZE)+1,(value / PERSON_ARRANGE)*Succ(TILE_Y_SIZE)+1,TILE_X_SIZE,TILE_Y_SIZE);
					PutSpriteEx(x*TILE_X_SIZE+_ABS_X,y*TILE_Y_SIZE-10+_ABS_Y,2,ARect,smLeftTop,Transparency);
				}
				else 
				{
					value = 29;
					ARect = Bounds((value % OBJECT_ARRANGE)*Succ(TILE_X_SIZE)+(9*Succ(TILE_X_SIZE)+1),(value / OBJECT_ARRANGE)*Succ(TILE_Y_SIZE)+(7*Succ(TILE_Y_SIZE)+1),TILE_X_SIZE,TILE_Y_SIZE);
					PutSpriteEx(x*TILE_X_SIZE+_ABS_X,(y-1)*TILE_Y_SIZE+_ABS_Y,2,ARect,smLeftTop,Transparency);
				}

				value = Main->Map->Map[maTile][x+APoint.x][y+APoint.y-1];
				if (Main->Map->IsForegroundTile((BYTE)value))
				{
					ARect = Bounds((value % TILE_ARRANGE)*Succ(TILE_X_SIZE)+1,(value / TILE_ARRANGE)*Succ(TILE_Y_SIZE)+1,TILE_X_SIZE,TILE_Y_SIZE);
					PutTile(x*TILE_X_SIZE+_ABS_X,(y-1)*TILE_Y_SIZE+_ABS_Y,1,ARect,smLeftTop);
				}

				value = Main->Map->Map[maObject][x+APoint.x][y+APoint.y-1];
				if (IS_FOREGROUND_OBJECT_TILE(value))
				{
					ARect = Bounds((value % OBJECT_ARRANGE)*Succ(TILE_X_SIZE)+(9*Succ(TILE_X_SIZE)+1),(value / OBJECT_ARRANGE)*Succ(TILE_Y_SIZE)+(7*Succ(TILE_Y_SIZE)+1),TILE_X_SIZE,TILE_Y_SIZE);
					PutSprite(x*TILE_X_SIZE+_ABS_X,(y-1)*TILE_Y_SIZE+_ABS_Y,2,ARect,smLeftTop);
				}
			}
			break;
	}
}

void CGameSystem::SetHangulColor(COLORREF color)
{
	HangulColor = color;
}

void CGameSystem::PrintHangul(int x, int y, const char* s)
{
	LPDIRECTDRAWSURFACE lpBackBuffer = DDGetBackBuffer();
	HDC DC;

	if ( lpBackBuffer->GetDC(&DC) == DD_OK)
	{
		SelectObject(DC,HangulFont);

		if (HangulTransparency)
			SetBkMode(DC,TRANSPARENT);

		SetTextColor(DC,HangulColor);
		TextOut(DC,x,y,s,strlen(s));

		lpBackBuffer->ReleaseDC(DC);
	}
}

BOOL CGameSystem::SendEvent(CEventQueue *EventQueue, TEventData *EventMessage)
{
	return EventQueue->PushEvent(EventMessage);
}

/* End of CGameSystem */
