
#ifndef __USYS_H

#define __USYS_H

#include "UTypes.h"
#include "UCompo.h"

class CGameSystem
{

	public:

		CGameSystem();
		~CGameSystem();

	private:

		void	ModifyClip(int &x, int &y, RECT &ARect, TSpriteMode mode);

	public:

		short	MAIN_CHARACTER;
		int		FlippingCount;
		DWORD	StartTickCount;
		float	FlipPerSecond;

		BOOL	HangulTransparency;
		COLORREF	HangulColor;
		HFONT	HangulFont;

		void	PutTile  (int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode);
		void	PutSprite(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode);
		void	DisplayObject(TMapAttribute MA, int x, int y, short value, POINT APoint, short aux);
		void	PutSpriteExHalf(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode);
		void	PutSpriteEx(int x, int y, int ImageNumber, RECT ARect, TSpriteMode mode, BYTE Transparency);

		void	SetHangulColor(COLORREF color);
		void	PrintHangul(int x, int y, const char* s);

		BOOL	SendEvent(CEventQueue *EventQueue, TEventData *EventMessage);
};

#endif