
#ifndef __UTYPES_H

#define __UTYPES_H

#include <windows.h>

// Component Part

typedef char STRING[256];

// Event Part

#define MAX_EVENT_QUEUE	10

typedef struct {
	WORD	Type;
	WORD	ID;
	union {
		struct {
			DWORD Param1;
			DWORD Param2;
		};
		POINT Pos;
	};
} TEventData;

const _ET_MOVE			= 1;

// Person Part

typedef enum tagAbility {
	abStrength, abInteligence, abConcentration, abEndurance, abAccuracy,
	abAgility, abWill, abPriety, abLuck, abLevel, MAX_TAbility
} TAbility;

typedef enum tagInternal {
	itHitPoint, itSpellPoint, itWhorlShien,
	itHitPointRecoveringTemplet, itSpellPointRecoveringTemplet, 
	itDefenseLevel, itDefenseMagic, itDisposition,
	itPoisonDepth, itSleepDepth, itFearDepth, itParalisisDepth, itStonizationDepth,	itUnconsciousDepth, itDeathDepth,
	itBreathRemainCount, itAntodoteBody, itLevitation, itTransparency,
	itLove, itHostile, itHostile1, itHostile2, itHostile3, itHostile4,
	itExperience, itPotentialExperience, MAX_TInternal
} TInternal;

typedef enum tagTMapAttribute {
	maTile, maObject, maField, maAttribute, maPerson, maFog, MAX_TMapAttribute
} TMapAttribute;

typedef enum tagTMapEvent {
	meOn, meIn, meHit, meTime, meWalkable, meBlocked, meLight, meDark, Num_TMapEvent
} TMapEvent;

typedef enum tagTSpriteMode {
	smLeftTop, smCentered
} TSpriteMode;

typedef enum tagTFaceDirection {
	fdUp, fdDown, fdLeft, fdRight
} TFaceDirection;

typedef enum tagTMagicType {
	mtNone, mtAttack, mtDefense, mtSummon, mtCure, mtEnvironment
} TMagicType;

typedef enum tagTMagicDestination {
	mdOne, mdAll, mdRandom, mdGround, mdParty
} TMagicDestination;

typedef enum tagTMagicNeed {
	mnNotNeed, mnFire, mnWater, mnAir, mnEarth, mnPoison,
	mnThing, mnCorpse, mnWeapon, mnShield, mnArmor, mnPlayer
} TMagicNeed;


#define MAX_PERSON		30
#define MAX_X_LINE		800
#define MAX_Y_LINE		600

#define TILE_X_SIZE		24
#define TILE_Y_SIZE		24

#define VIEW_WIDE_X		27
#define VIEW_WIDE_Y		20

#define TILE_ARRANGE	12
#define OBJECT_ARRANGE	9
#define PERSON_ARRANGE	9
#define FIELD_ARRANGE	9
#define EQUIP_ARRANGE	7

#define __FIELD_EMPTY	0
#define __FIELD_FIRE	1
#define __FIELD_VACUUM	2
#define __FIELD_POISON	3
#define __FIELD_SLEEP	4
#define __FIELD_ELETRIC	5
#define __FIELD_ENERGY	6
#define __FIELD_FORCE	7

#define __EVENT_BIT      0x03
#define __FIELD_BIT      0x07
#define __SEARCHABLE_BIT 0x10
#define __FIXED_AIR_BIT  0x20
#define __WALKABLE_BIT   0x40
#define __BLIGHT_BIT     0x80

#define IS_FOREGROUND_TILE_TOWN(x) ( ((x) == 100) || ((x) == 102) || InRange(x,104,108) || ((x) == 110) ||\
				((x) == 112) || ((x) == 114) ||  ((x) == 118) ||  ((x) == 120) ||  ((x) == 122) ||\
				InRange(x,124,128) || ((x) == 130) ||  ((x) == 132) ||  ((x) == 134) ||  ((x) == 138))

#define IS_FOREGROUND_TILE_DEN(x) ( ((x) == 120) || ((x) == 122) || InRange(x,124,126) || ((x) == 128) ||\
				((x) == 130) || ((x) == 132) || ((x) == 134) || ((x) == 138) )

#define IS_FOREGROUND_OBJECT_TILE(x) ( ((x) == 5) || ((x) == 11) || ((x) == 24) || InRange(x,42,45) )\

#define IS_WALL_TILE_TOWN(x) ( InRange(x,96,99) || ((x) == 112) || ((x) == 113) || ((x) == 115) || ((x) == 124) || ((x) == 125) || ((x) == 127) )
#define IS_WALL_TILE_DEN(x) ( ((x) == 124) || ((x) == 125) || ((x) == 127) )

#define IS_STAIRS_TILE(x) InRange(x,140,143)
#define IS_MOVABLE_TILE(x) ( InRange(x,1,89) || ((x) == 140) || ((x) == 143) ) 
#define IS_MOVABLE_OBJECT_TILE(x) ( InRange(x,0,3) || ((x) == 5) || ((x) == 7) || ((x) == 9) ||\
				((x) == 11) || ((x) == 24) || ((x) == 51) || InRange(x,31,45) || InRange(x,100,255))

#define IS_MOVABLE_FIELD_TILE(x) ( ((x) == __FIELD_EMPTY) || ((x) == __FIELD_FIRE) || ((x) == __FIELD_VACUUM) ||\
				((x) == __FIELD_POISON) || ((x) == __FIELD_SLEEP) || ((x) == __FIELD_ENERGY) ) 
#define IS_PASSABLE_OBJECT_TILE(x) ( InRange(x,0,2) || ((x) == 7) || ((x) == 9) || ((x) == 31) || \
				InRange(x,42,45) || InRange(x,100,255) )
#define IS_PASSABLE_FIELD_TILE(x) InRange(x,0,5)

#define Pred(x) ((x)-1)
#define Succ(x) ((x)+1)
#define Random(x) (rand() % (x))

POINT	Point(LONG x, LONG y);
RECT	Rect(LONG left, LONG top, LONG right, LONG bottom);
RECT	Bounds(LONG left, LONG top, LONG width, LONG height);
BOOL	InRange(INT32 Value, INT32 Min, INT32 Max);
void	GetCursorPosEx(POINT *pos);

#endif
