unit Info;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, XaudioPlayer;

type
  TInfoForm = class(TForm)
    InputGroup: TGroupBox;
    OutputGroup: TGroupBox;
    InputNameLabel: TLabel;
    InputModuleLabel: TLabel;
    InputNameText: TStaticText;
    InputModuleText: TStaticText;
    DllInfoBox: TGroupBox;
    LibraryVersionLabel: TLabel;
    LibraryVersionText: TStaticText;
    RefreshButton: TButton;
    OutputNameLabel: TLabel;
    OutputModuleLabel: TLabel;
    OutputNameText: TStaticText;
    OutputModuleText: TStaticText;
    ListOutputsButton: TButton;
    ListInputModulesButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure RefreshButtonClick(Sender: TObject);
    procedure ListInputModulesButtonClick(Sender: TObject);
    procedure ListOutputsButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InfoForm: TInfoForm;

implementation

uses Player, Modules;

{$R *.DFM}

procedure TInfoForm.FormCreate(Sender: TObject);
var
  ApiMajor:    Cardinal;
  ApiMinor:    Cardinal;
  ApiRevision: Cardinal;
  ApiVersion:  Cardinal;
begin
  ApiVersion  := XaudioPlayer.xaudio_get_api_version(XA_API_ID_ASYNC);
  ApiMajor    := (ApiVersion shr 16) and $FF;
  ApiMinor    := (ApiVersion shr 8) and $FF;
  ApiRevision := (ApiVersion) and $FF;
  LibraryVersionText.Caption := Format('%d.%d.%d',
                                       [ApiMajor, ApiMinor, ApiRevision]);
end;

procedure TInfoForm.RefreshButtonClick(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.GetInputModule;
  PlayerForm.XaudioPlayer.GetOutputModule;
end;

procedure TInfoForm.ListInputModulesButtonClick(Sender: TObject);
begin
  ModulesForm.TreeView.Items.Clear;
  ModulesForm.TreeView.Items.AddChild(ModulesForm.TreeView.Items.GetFirstNode, 'Input Modules');
  PlayerForm.XaudioPlayer.InputModulesList;
end;

procedure TInfoForm.ListOutputsButtonClick(Sender: TObject);
begin
  ModulesForm.TreeView.Items.Clear;
  ModulesForm.TreeView.Items.AddChild(ModulesForm.TreeView.Items.GetFirstNode, 'Output Modules');
  PlayerForm.XaudioPlayer.OutputModulesList;
end;

end.
