unit Volume;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, XaudioPlayer, ExtCtrls;

type
  TVolumeForm = class(TForm)
    MasterTrackBar: TTrackBar;
    MuteCheckBox: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    PcmTrackBar: TTrackBar;
    Label3: TLabel;
    BalanceTrackBar: TTrackBar;
    ChannelsGroup: TRadioGroup;
    StereoButton: TRadioButton;
    MonoLeftButton: TRadioButton;
    MonoRightButton: TRadioButton;
    MonoMixButton: TRadioButton;
    procedure MuteCheckBoxClick(Sender: TObject);
    procedure MasterTrackBarChange(Sender: TObject);
    procedure PcmTrackBarChange(Sender: TObject);
    procedure BalanceTrackBarChange(Sender: TObject);
    procedure StereoButtonClick(Sender: TObject);
    procedure MonoLeftButtonClick(Sender: TObject);
    procedure MonoRightButtonClick(Sender: TObject);
    procedure MonoMixButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VolumeForm: TVolumeForm;

implementation

uses Player;

{$R *.DFM}



procedure TVolumeForm.MuteCheckBoxClick(Sender: TObject);
begin
  if TCheckBox(Sender).Checked then
    PlayerForm.XaudioPlayer.OutputMute
  else
    PlayerForm.XaudioPlayer.OutputUnmute;
end;

procedure TVolumeForm.MasterTrackBarChange(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputVolume(XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                          XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                          MasterTrackBar.Position);
end;

procedure TVolumeForm.PcmTrackBarChange(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputVolume(XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                          PcmTrackBar.Position,
                                          XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD);
end;

procedure TVolumeForm.BalanceTrackBarChange(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputVolume(BalanceTrackBar.Position,
                                          XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                          XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD);
end;

procedure TVolumeForm.StereoButtonClick(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputChannels(0)
end;

procedure TVolumeForm.MonoLeftButtonClick(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputChannels(1)
end;

procedure TVolumeForm.MonoRightButtonClick(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputChannels(2)
end;

procedure TVolumeForm.MonoMixButtonClick(Sender: TObject);
begin
  PlayerForm.XaudioPlayer.SetOutputChannels(3)
end;

end.
