// EqualizerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlayerApp.h"
#include "PlayerDlg.h"
#include "EqualizerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CPlayerDlg *PlayerDialog;
CEqualizerDlg *EqualizerDialog = NULL;

/////////////////////////////////////////////////////////////////////////////
// CEqualizerDlg dialog


CEqualizerDlg::CEqualizerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEqualizerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEqualizerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CEqualizerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEqualizerDlg)
	DDX_Control(pDX, IDC_ENABLE_EQ_CHECKBOX, m_EnableEQCheckBox);
	DDX_Control(pDX, IDC_SLIDER8, m_Slider8);
	DDX_Control(pDX, IDC_SLIDER7, m_Slider7);
	DDX_Control(pDX, IDC_SLIDER6, m_Slider6);
	DDX_Control(pDX, IDC_SLIDER5, m_Slider5);
	DDX_Control(pDX, IDC_SLIDER4, m_Slider4);
	DDX_Control(pDX, IDC_SLIDER3, m_Slider3);
	DDX_Control(pDX, IDC_SLIDER2, m_Slider2);
	DDX_Control(pDX, IDC_SLIDER1, m_Slider1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEqualizerDlg, CDialog)
	//{{AFX_MSG_MAP(CEqualizerDlg)
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_ENABLE_EQ_CHECKBOX, OnEnableEqCheckbox)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEqualizerDlg message handlers

BOOL CEqualizerDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// ask for the current equalizer settings
    PlayerDialog->m_Player->GetCodecEqualizer();
	
    // set the range for the sliders
    m_Slider1.SetRange(-100,100, TRUE);
    m_Slider2.SetRange(-100,100, TRUE);
    m_Slider3.SetRange(-100,100, TRUE);
    m_Slider4.SetRange(-100,100, TRUE);
    m_Slider5.SetRange(-100,100, TRUE);
    m_Slider6.SetRange(-100,100, TRUE);
    m_Slider7.SetRange(-100,100, TRUE);
    m_Slider8.SetRange(-100,100, TRUE);

    // set the initial position for the sliders
    m_Slider1.SetPos(0);
    m_Slider2.SetPos(0);
    m_Slider3.SetPos(0);
    m_Slider4.SetPos(0);
    m_Slider5.SetPos(0);
    m_Slider6.SetPos(0);
    m_Slider7.SetPos(0);
    m_Slider8.SetPos(0);

    return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEqualizerDlg::UpdateValues()
{
    XA_EqualizerInfo EQ;

    if (m_EnableEQCheckBox.GetCheck() == FALSE) {
        // unset the equalizer
        PlayerDialog->m_Player->SetCodecEqualizer(NULL);
        return;
    }

    // compute channel bands;
    EQ.left[ 0] = -m_Slider1.GetPos();
    EQ.left[ 1] = -m_Slider2.GetPos();
    EQ.left[ 2] = -m_Slider3.GetPos();
    EQ.left[ 3] = -m_Slider3.GetPos();
    EQ.left[ 4] = -m_Slider4.GetPos();
    EQ.left[ 5] = -m_Slider4.GetPos();
    EQ.left[ 6] = -m_Slider5.GetPos();
    EQ.left[ 7] = -m_Slider5.GetPos();
    EQ.left[ 8] = -m_Slider6.GetPos();
    EQ.left[ 9] = -m_Slider6.GetPos();
    EQ.left[10] = -m_Slider6.GetPos();
    EQ.left[11] = -m_Slider6.GetPos();
    EQ.left[12] = -m_Slider6.GetPos();
    EQ.left[13] = -m_Slider6.GetPos();
    EQ.left[14] = -m_Slider7.GetPos();
    EQ.left[15] = -m_Slider7.GetPos();
    EQ.left[16] = -m_Slider7.GetPos();
    EQ.left[17] = -m_Slider7.GetPos();
    EQ.left[18] = -m_Slider7.GetPos();
    EQ.left[19] = -m_Slider7.GetPos();
    EQ.left[20] = -m_Slider8.GetPos();
    EQ.left[21] = -m_Slider8.GetPos();
    EQ.left[22] = -m_Slider8.GetPos();
    EQ.left[23] = -m_Slider8.GetPos();
    EQ.left[24] = -m_Slider8.GetPos();
    EQ.left[25] = -m_Slider8.GetPos();
    EQ.left[26] = -m_Slider8.GetPos();
    EQ.left[27] = -m_Slider8.GetPos();
    EQ.left[28] = -m_Slider8.GetPos();
    EQ.left[29] = -m_Slider8.GetPos();
    EQ.left[30] = -m_Slider8.GetPos();
    EQ.left[31] = -m_Slider8.GetPos();

    // right channel is same as left
    for (int i=0; i<sizeof(EQ.right)/sizeof(EQ.right[0]); i++) {
        EQ.right[i] = EQ.left[i];
    }

    PlayerDialog->m_Player->SetCodecEqualizer(&EQ);
}


void CEqualizerDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
    UpdateValues();	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CEqualizerDlg::OnEnableEqCheckbox() 
{
    UpdateValues();	
}

