// InfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlayerApp.h"
#include "PlayerDlg.h"
#include "InfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CPlayerDlg *PlayerDialog;
CInfoDlg *InfoDialog = NULL;

/////////////////////////////////////////////////////////////////////////////
// CInfoDlg dialog


CInfoDlg::CInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInfoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInfoDlg)
	DDX_Control(pDX, IDC_LIBRARY_VERSION_LABEL, m_LibraryVersionLabel);
	DDX_Control(pDX, IDC_OUTPUT_LIST, m_OutputList);
	DDX_Control(pDX, IDC_INPUT_LIST, m_InputList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CInfoDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInfoDlg message handlers

BOOL CInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    // vet version info
    int version_id = xaudio_get_api_version(XA_API_ID_ASYNC);
    char version_string[128];
    sprintf(version_string, "Async API Version %d.%d.%d",
            (version_id >> 16) & 0xFF,
            (version_id >>  8) & 0xFF,
            (version_id      ) & 0xFF);
    m_LibraryVersionLabel.SetWindowText(version_string);
            
	// ask for the list of input and output modules
    PlayerDialog->m_Player->InputModulesList();
    PlayerDialog->m_Player->OutputModulesList();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
