// PlayerApp.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "PlayerApp.h"
#include "PlayerDlg.h"
#include "InfoDlg.h"
#include "VolumeDlg.h"
#include "EqualizerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Globals
CPlayerDlg *PlayerDialog;

/////////////////////////////////////////////////////////////////////////////
// CMfcPlayerApp

BEGIN_MESSAGE_MAP(CPlayerApp, CWinApp)
	//{{AFX_MSG_MAP(CPlayerApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlayerApp construction

CPlayerApp::CPlayerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPlayerApp object

CPlayerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CPlayerApp initialization

BOOL CPlayerApp::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

    PlayerDialog = new CPlayerDlg;
	m_pMainWnd = PlayerDialog;
	int nResponse = PlayerDialog->DoModal();
    delete PlayerDialog;

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer constructor
SamplePlayer::SamplePlayer(HINSTANCE instance): 
    XaudioPlayer(instance), m_Scrolling(FALSE), m_State(XA_PLAYER_STATE_STOPPED) 
{
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyReady
void
SamplePlayer::OnNotifyReady()
{
    // set some of the player's global options
    PlayerDialog->m_Player->SetPlayerMode(XA_PLAYER_MODE_OUTPUT_AUTO_CLOSE_ON_STOP);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyNack
void
SamplePlayer::OnNotifyNack(XA_NackInfo *info)
{
    char message[256];
    sprintf(message,"Command %d failed\n[%s]", 
            info->command,
            xaudio_error_string(info->code));
    MessageBox(NULL, message, "Xaudio Command Failed", MB_OK | MB_ICONSTOP);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyPlayerState
void 
SamplePlayer::OnNotifyPlayerState(XA_PlayerState state)
{
    CString state_name;

    // compute state name
    switch (state) {
      case XA_PLAYER_STATE_PLAYING:
        state_name = "PLAYING";
        // change the name of the play button to "Pause"
        PlayerDialog->m_PlayButton.SetWindowText("Pause");
        break;

      case XA_PLAYER_STATE_EOF:
        state_name = "EOF";
        // if we had a playlist, now would be the time to tell
        // the player to open the next item in the list by 
        // calling InputOpen() with the next name. This would
        // give a perfect queuing effect (no gap between songs)
        // Since we do not have a playlist, we'll just rewind
        // the stream to the beginning.
        PlayerDialog->m_Player->Seek(0,1);
        break;

      case XA_PLAYER_STATE_STOPPED:
        state_name = "STOPPED";
        // change the name of the play button to "Play"
        PlayerDialog->m_PlayButton.SetWindowText("Play");
        break;

      case XA_PLAYER_STATE_PAUSED:
        // if we're sliding the bar, ignore this message
        if (m_Scrolling) return;
        state_name = "PAUSED";
        // change the name of the play button to "Play"
        PlayerDialog->m_PlayButton.SetWindowText("Play");
        break;

      default: return;
    }

    // remember the state
    m_State = state;

    // display the current state
    PlayerDialog->m_StateLabel.SetWindowText(state_name);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyNack
void 
SamplePlayer::OnNotifyInputName(const char *name)
{
    // a file has been openned
    PlayerDialog->m_NameLabel.SetWindowText(name);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyInputPosition
void 
SamplePlayer::OnNotifyInputPosition(unsigned long offset, unsigned long range)
{
    // show position on the slider
    PlayerDialog->m_Slider.SetPos(offset);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyInputState
void 
SamplePlayer::OnNotifyInputState(XA_InputState state)
{
    BOOL enabled;

    switch(state) {
      case XA_INPUT_STATE_OPEN:
        // enable the play and stop buttons, and the slider
        enabled = TRUE;
        // autoplay
        if (PlayerDialog->m_AutoPlayCheckBox.GetCheck()) Play();
        break;

      case XA_INPUT_STATE_CLOSED:
        // disable the play and stop buttons, and the slider
        enabled = FALSE;
        break;
    }

    PlayerDialog->m_PlayButton.EnableWindow(enabled);
    PlayerDialog->m_StopButton.EnableWindow(enabled);
    PlayerDialog->m_Slider.EnableWindow(enabled);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyInputDuration
void 
SamplePlayer::OnNotifyInputDuration(unsigned long duration)
{
    char caption[128];

    sprintf(caption, "%d seconds", duration);
    PlayerDialog->m_DurationLabel.SetWindowText(caption);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyInputTimecode
void 
SamplePlayer::OnNotifyInputTimecode(XA_TimecodeInfo *info)
{
    char caption[128];

    sprintf(caption, "%02d:%02d:%02d", 
            info->h,
            info->m,
            info->s);
    PlayerDialog->m_TimecodeLabel.SetWindowText(caption);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyInputStreamInfo
void 
SamplePlayer::OnNotifyInputStreamInfo(XA_StreamInfo *info)
{
    char caption[128];

    sprintf(caption, "MPEG %d Layer %d, %d kbps, %d Hz", 
            info->level,
            info->layer,
            info->bitrate,
            info->frequency);
    PlayerDialog->m_TypeLabel.SetWindowText(caption);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyInputModuleInfo
void 
SamplePlayer::OnNotifyInputModuleInfo(XA_ModuleInfo *info)
{
    if (InfoDialog == NULL) return;
    InfoDialog->m_InputList.AddString(info->name);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyOutputState
void 
SamplePlayer::OnNotifyOutputState(XA_OutputState state)
{
    switch(state) {
      case XA_OUTPUT_STATE_OPEN:
        // enable the volume button
        PlayerDialog->m_VolumeButton.EnableWindow(TRUE);
        break;

      case XA_INPUT_STATE_CLOSED:
        // disable volume button
        PlayerDialog->m_VolumeButton.EnableWindow(FALSE);
        break;
    }
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyOutputModuleInfo
void 
SamplePlayer::OnNotifyOutputModuleInfo(XA_ModuleInfo *info)
{
    if (InfoDialog == NULL) return;
    InfoDialog->m_OutputList.AddString(info->name);    
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyOutputMasterLevel
void 
SamplePlayer::OnNotifyOutputMasterLevel(unsigned char level)
{
    if (VolumeDialog == NULL) return;
    VolumeDialog->m_MasterSlider.SetPos(level);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyOutputPcmLevel
void 
SamplePlayer::OnNotifyOutputPcmLevel(unsigned char level)
{
    if (VolumeDialog == NULL) return;
    VolumeDialog->m_PcmSlider.SetPos(level);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyOutputBalance
void 
SamplePlayer::OnNotifyOutputBalance(unsigned char balance)
{
    if (VolumeDialog == NULL) return;
    VolumeDialog->m_BalanceSlider.SetPos(balance);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyCodecEqualizer
void 
SamplePlayer::OnNotifyCodecEqualizer(XA_EqualizerInfo *equalizer)
{
    if (EqualizerDialog == NULL) return;

    // if the equalizer if NULL, it means it's disabled
    if (equalizer == NULL) {
        EqualizerDialog->m_EnableEQCheckBox.SetCheck(FALSE);
    } else {
        EqualizerDialog->m_EnableEQCheckBox.SetCheck(TRUE);

        // set the slider positions
        EqualizerDialog->m_Slider1.SetPos(-equalizer->left[ 0]);
        EqualizerDialog->m_Slider2.SetPos(-equalizer->left[ 1]);
        EqualizerDialog->m_Slider3.SetPos(-equalizer->left[ 2]);
        EqualizerDialog->m_Slider4.SetPos(-equalizer->left[ 4]);
        EqualizerDialog->m_Slider5.SetPos(-equalizer->left[ 6]);
        EqualizerDialog->m_Slider6.SetPos(-equalizer->left[ 8]);
        EqualizerDialog->m_Slider7.SetPos(-equalizer->left[14]);
        EqualizerDialog->m_Slider8.SetPos(-equalizer->left[20]);
    }
}

