// PlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlayerApp.h"
#include "PlayerDlg.h"
#include "InfoDlg.h"
#include "VolumeDlg.h"
#include "EqualizerDlg.h"
#include "UrlDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlayerDlg dialog

CPlayerDlg::CPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlayerDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_XAUDIO_ICON);
}

void CPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlayerDlg)
	DDX_Control(pDX, IDC_AUTOPLAY_CHECKBOX, m_AutoPlayCheckBox);
	DDX_Control(pDX, IDC_INFO_BUTTON, m_InfoButton);
	DDX_Control(pDX, IDC_VOLUME_BUTTON, m_VolumeButton);
	DDX_Control(pDX, IDC_STOP_BUTTON, m_StopButton);
	DDX_Control(pDX, IDC_PLAY_BUTTON, m_PlayButton);
	DDX_Control(pDX, IDC_DURATION_LABEL, m_DurationLabel);
	DDX_Control(pDX, IDC_TYPE_LABEL, m_TypeLabel);
	DDX_Control(pDX, IDC_TIMECODE_LABEL, m_TimecodeLabel);
	DDX_Control(pDX, IDC_SLIDER, m_Slider);
	DDX_Control(pDX, IDC_NAME_LABEL, m_NameLabel);
	DDX_Control(pDX, IDC_STATE_LABEL, m_StateLabel);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CPlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PLAY_BUTTON, OnPlayButton)
	ON_BN_CLICKED(IDC_OPEN_FILE_BUTTON, OnOpenFileButton)
	ON_BN_CLICKED(IDC_STOP_BUTTON, OnStopButton)
	ON_BN_CLICKED(IDC_OPEN_URL_BUTTON, OnOpenUrlButton)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_ABOUT_BUTTON, OnAboutButton)
	ON_BN_CLICKED(IDC_INFO_BUTTON, OnInfoButton)
	ON_BN_CLICKED(IDC_VOLUME_BUTTON, OnVolumeButton)
	ON_BN_CLICKED(IDC_EQUALIZER_BUTTON, OnEqualizerButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlayerDlg message handlers

BOOL CPlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
    // set some of the control's properties
    m_Slider.SetRange(0,400);

    // instanciate an Xaudio Player
    m_Player = new SamplePlayer(AfxGetResourceHandle());
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CPlayerDlg::DestroyWindow() 
{
	// delete the Xaudio player
    m_Player->Stop();
	delete m_Player;

	return CDialog::DestroyWindow();
}

void CPlayerDlg::OnOpenFileButton() 
{
	// open a file
	CFileDialog *dialog;

	dialog = new CFileDialog(TRUE, 
							"mp3",
							"",
							OFN_FILEMUSTEXIST    | 
							OFN_HIDEREADONLY     |
							OFN_EXPLORER,
							"MPEG Audio Files {*.mpg;*.mp1;*.mp2;*.mp3}|*.mpg;*.mp1;*.mp2;*.mp3|All Files {*.*}|*.*||");


	int ret;
	ret = dialog->DoModal();
	if (ret == IDOK) {
        // a file was selected
		m_Player->InputOpen(dialog->GetPathName());
	}

	delete dialog;
	
}

void CPlayerDlg::OnOpenUrlButton() 
{
	CUrlDlg *dialog;

	dialog = new CUrlDlg();


	int ret;
	ret = dialog->DoModal();
	if (ret == IDOK) {
		// an URL was entered
		m_Player->InputOpen(dialog->m_URL);
	}
	delete dialog;
}

void CPlayerDlg::OnPlayButton() 
{
    switch (m_Player->m_State) {
      case XA_PLAYER_STATE_STOPPED:
      case XA_PLAYER_STATE_PAUSED:
      case XA_PLAYER_STATE_EOF:
        m_Player->Play();
        break;

      case XA_PLAYER_STATE_PLAYING:
        m_Player->Pause();
        break;
    }
}


void CPlayerDlg::OnStopButton() 
{
	m_Player->Stop();
}


void CPlayerDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
    if (pScrollBar->m_hWnd == m_Slider.m_hWnd) {
        switch (nSBCode) {
          case SB_LINELEFT:
          case SB_LINERIGHT:
          case SB_PAGELEFT:
          case SB_PAGERIGHT:
            if (m_Player->m_Scrolling == FALSE) {
                m_Player->m_Scrolling = TRUE;
                m_Player->Pause();
            }
            break;

          case SB_ENDSCROLL: 
            m_Player->Seek(m_Slider.GetPos(), 400);
            if (m_Player->m_Scrolling) {
                m_Player->m_Scrolling = FALSE; 
                if (m_Player->m_State == XA_PLAYER_STATE_PLAYING) {
                    m_Player->Play();
                }
            }
            break;

          case SB_THUMBTRACK:
            if (m_Player->m_Scrolling == FALSE) {
                m_Player->m_Scrolling = TRUE;
                m_Player->Pause();
            }
            // fallthrough
          case SB_THUMBPOSITION: 
            m_Player->Seek(nPos, 400);
            break;
        }
    }
    CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPlayerDlg::OnAboutButton() 
{
    CAboutDlg dialog;
    dialog.DoModal();
}

void CPlayerDlg::OnInfoButton() 
{
    InfoDialog = new CInfoDlg;
    InfoDialog->DoModal();
    delete InfoDialog;
    InfoDialog = NULL;
}

void CPlayerDlg::OnVolumeButton() 
{
    VolumeDialog = new CVolumeDlg;
    VolumeDialog->DoModal();
    delete VolumeDialog;
    VolumeDialog = NULL;
}

void CPlayerDlg::OnEqualizerButton() 
{
    EqualizerDialog = new CEqualizerDlg;
    EqualizerDialog->DoModal();
    delete EqualizerDialog;
    EqualizerDialog = NULL;
}
