// VolumeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlayerApp.h"
#include "PlayerDlg.h"
#include "VolumeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CPlayerDlg *PlayerDialog;
CVolumeDlg *VolumeDialog = NULL;

/////////////////////////////////////////////////////////////////////////////
// CVolumeDlg dialog


CVolumeDlg::CVolumeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVolumeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVolumeDlg)
	//}}AFX_DATA_INIT
}


void CVolumeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVolumeDlg)
	DDX_Control(pDX, IDC_PCM_SLIDER, m_PcmSlider);
	DDX_Control(pDX, IDC_MASTER_SLIDER, m_MasterSlider);
	DDX_Control(pDX, IDC_BALANCE_SLIDER, m_BalanceSlider);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CVolumeDlg, CDialog)
	//{{AFX_MSG_MAP(CVolumeDlg)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVolumeDlg message handlers

BOOL CVolumeDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// ask for the current volume
    PlayerDialog->m_Player->GetOutputVolume();

    // set the range of the sliders
    m_MasterSlider.SetRange(0,100);
    m_PcmSlider.SetRange(0,100);
    m_BalanceSlider.SetRange(0,100);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CVolumeDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
    if (pScrollBar->m_hWnd == m_MasterSlider.m_hWnd) {
        // this is the master volume 
        PlayerDialog->m_Player->SetOutputVolume(XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                                XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                                m_MasterSlider.GetPos());
    } else if (pScrollBar->m_hWnd == m_PcmSlider.m_hWnd) {
        // this is the pcm volume 
        PlayerDialog->m_Player->SetOutputVolume(XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                                m_PcmSlider.GetPos(),
                                                XA_OUTPUT_VOLUME_IGNORE_FIELD);
    } else if (pScrollBar->m_hWnd == m_BalanceSlider.m_hWnd) {
        // this is the balance 
        PlayerDialog->m_Player->SetOutputVolume(m_BalanceSlider.GetPos(),
                                                XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                                XA_OUTPUT_VOLUME_IGNORE_FIELD);
    }

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
