unit player;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, XaudioPlayer;

type
  TForm1 = class(TForm)
    XaudioPlayer1: TXaudioPlayer;
    XaudioPlayer2: TXaudioPlayer;
    Button1: TButton;
    Button2: TButton;
    PitchBar1: TTrackBar;
    PitchBar2: TTrackBar;
    OpenDialog1: TOpenDialog;
    VolumeBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    VolumeBar2: TTrackBar;
    GroupBox1: TGroupBox;
    UseWaveDriverRadioButton: TRadioButton;
    UseDirectSoundRadioButton: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure PitchBar1Change(Sender: TObject);
    procedure PitchBar2Change(Sender: TObject);
    procedure VolumeBar1Change(Sender: TObject);
    procedure VolumeBar2Change(Sender: TObject);
    procedure ShowNack(Command: Byte; Code: Smallint);
    procedure XaudioPlayer1NotifyNack(Sender: TXaudioPlayer; Command: Byte;
      Code: Smallint);
    procedure XaudioPlayer2NotifyNack(Sender: TXaudioPlayer; Command: Byte;
      Code: Smallint);
    procedure UseDirectSoundRadioButtonClick(Sender: TObject);
    procedure UseWaveDriverRadioButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     XaudioPlayer1.OutputModuleRegister('dsound_output_module_register@xa_dsound_output.dll');
     XaudioPlayer1.SetPlayerEnvironmentInteger('OUTPUT.DIRECTSOUND.WINDOW', Form1.Handle);
     XaudioPlayer1.SetOutputName('/dev/dsound/0');
     XaudioPlayer2.OutputModuleRegister('dsound_output_module_register@xa_dsound_output.dll');
     XaudioPlayer2.SetPlayerEnvironmentInteger('OUTPUT.DIRECTSOUND.WINDOW', Form1.Handle);
     XaudioPlayer2.SetOutputName('/dev/dsound/0');
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     if OpenDialog1.Execute then
       begin
         XaudioPlayer1.InputOpen(OpenDialog1.FileName);
         XaudioPlayer1.Play;
       end
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
     if OpenDialog1.Execute then
       begin
         XaudioPlayer2.InputOpen(OpenDialog1.FileName);
         XaudioPlayer2.Play;
       end
end;

procedure TForm1.PitchBar1Change(Sender: TObject);
begin
     XaudioPlayer1.SetPlayerEnvironmentInteger('OUTPUT.DIRECTSOUND.PITCH', PitchBar1.Position)
end;

procedure TForm1.PitchBar2Change(Sender: TObject);
begin
     XaudioPlayer2.SetPlayerEnvironmentInteger('OUTPUT.DIRECTSOUND.PITCH', PitchBar2.Position)
end;

procedure TForm1.VolumeBar1Change(Sender: TObject);
begin
     XaudioPlayer1.SetOutputVolume(XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                   VolumeBar1.Position,
                                   XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD)
end;

procedure TForm1.VolumeBar2Change(Sender: TObject);
begin
     XaudioPlayer2.SetOutputVolume(XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                   VolumeBar2.Position,
                                   XaudioPlayer.XA_OUTPUT_VOLUME_IGNORE_FIELD)
end;

procedure TForm1.ShowNack(Command: Byte; Code: Smallint);
var
  CommandString: String;
begin
  if (Command = XA_MSG_COMMAND_OUTPUT_MODULE_REGISTER) then
    CommandString := 'OutputModuleRegister'
  else
    CommandString := IntToStr(Command);

  MessageDlg('Command Failed [' +
             CommandString +
             '] (' +
             XaudioPlayer.xaudio_error_string(Code)
             + ')', mtError, [mbOk], 0);
end;

procedure TForm1.XaudioPlayer1NotifyNack(Sender: TXaudioPlayer;
  Command: Byte; Code: Smallint);
begin
  ShowNack(Command, Code);
end;

procedure TForm1.XaudioPlayer2NotifyNack(Sender: TXaudioPlayer;
  Command: Byte; Code: Smallint);
begin
  ShowNack(Command, Code);
end;

procedure TForm1.UseDirectSoundRadioButtonClick(Sender: TObject);
begin
     XaudioPlayer1.SetOutputName('/dev/dsound/0');
     XaudioPlayer2.SetOutputName('/dev/dsound/0');
end;

procedure TForm1.UseWaveDriverRadioButtonClick(Sender: TObject);
begin
     XaudioPlayer1.SetOutputName('/dev/wave/0');
     XaudioPlayer2.SetOutputName('/dev/wave/0');
end;

end.
