// MfcPlayer.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "MfcPlayer.h"
#include "MfcPlayerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Globals
CMfcPlayerDlg *PlayerDialog = NULL;

/////////////////////////////////////////////////////////////////////////////
// CMfcPlayerApp

BEGIN_MESSAGE_MAP(CMfcPlayerApp, CWinApp)
	//{{AFX_MSG_MAP(CMfcPlayerApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcPlayerApp construction

CMfcPlayerApp::CMfcPlayerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMfcPlayerApp object

CMfcPlayerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMfcPlayerApp initialization

BOOL CMfcPlayerApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	PlayerDialog = new CMfcPlayerDlg;
	m_pMainWnd = PlayerDialog;
	PlayerDialog->DoModal();
    delete PlayerDialog;

    // Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer constructor
SamplePlayer::SamplePlayer(HINSTANCE instance): XaudioPlayer(instance)
{
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyReady
void
SamplePlayer::OnNotifyReady()
{
    // register the directsound module
    OutputModuleRegister("dsound_output_module_register@xa_dsound_output.dll");

    // set the directound modules' environemnt variable for the window
    SetPlayerEnvironmentInteger("OUTPUT.DIRECTSOUND.WINDOW",
                                (unsigned long)PlayerDialog->m_hWnd);

    // Set the priority to normal, so that one thread does not block to
    // other for too much time
    SetPriority(XA_CONTROL_PRIORITY_NORMAL);
}

/////////////////////////////////////////////////////////////////////////////
// SamplePlayer::OnNotifyNack
void
SamplePlayer::OnNotifyNack(XA_NackInfo *info)
{
    char message[256];
    sprintf(message,"Command %d failed\n[%s]", 
            info->command,
            xaudio_error_string(info->code));
    MessageBox(NULL, message, "Xaudio Command Failed", MB_OK | MB_ICONSTOP);
}

