// MfcPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MfcPlayer.h"
#include "MfcPlayerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcPlayerDlg dialog

CMfcPlayerDlg::CMfcPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMfcPlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMfcPlayerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_XAUDIO_ICON);
}

void CMfcPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMfcPlayerDlg)
	DDX_Control(pDX, IDC_VOLUME_SLIDER2, m_VolumeSlider2);
	DDX_Control(pDX, IDC_VOLUME_SLIDER1, m_VolumeSlider1);
	DDX_Control(pDX, IDC_PITCH_SLIDER2, m_PitchSlider2);
	DDX_Control(pDX, IDC_PITCH_SLIDER1, m_PitchSlider1);
	DDX_Control(pDX, IDC_FILE2_BUTTON, m_File2Button);
	DDX_Control(pDX, IDC_FILE1_BUTTON, m_File1Button);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMfcPlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CMfcPlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_USE_DIRECTSOUND_RADIO, OnUseDirectsoundRadio)
	ON_BN_CLICKED(IDC_USE_WAVE_RADIO, OnUseWaveRadio)
	ON_BN_CLICKED(IDC_FILE1_BUTTON, OnFile1Button)
	ON_BN_CLICKED(IDC_FILE2_BUTTON, OnFile2Button)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcPlayerDlg message handlers

BOOL CMfcPlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
    // check the directsound radio button
    ((CButton *)(GetDlgItem(IDC_USE_DIRECTSOUND_RADIO)))->SetCheck(TRUE);

	// set the range for the pitch sliders
    m_PitchSlider1.SetRange(0,2000,TRUE);
    m_PitchSlider1.SetPos(1000);
    m_PitchSlider2.SetRange(0,2000,TRUE);
    m_PitchSlider2.SetPos(1000);

  	// set the range for the volume sliders
    m_VolumeSlider1.SetRange(0,100,TRUE);
    m_VolumeSlider1.SetPos(100);
    m_VolumeSlider2.SetRange(0,100,TRUE);
    m_VolumeSlider2.SetPos(100);

    // instanciate an Xaudio Player
    m_Player1 = new SamplePlayer(AfxGetResourceHandle());
    m_Player2 = new SamplePlayer(AfxGetResourceHandle());

    // set some player parameters
    m_Player1->SetOutputName("/dev/dsound/0");	
    m_Player2->SetOutputName("/dev/dsound/0");	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CMfcPlayerDlg::DestroyWindow() 
{
    m_Player1->Stop();
    m_Player2->Stop();
    delete m_Player1;
    delete m_Player2;

	return CDialog::DestroyWindow();
}

void CMfcPlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMfcPlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMfcPlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMfcPlayerDlg::OnUseDirectsoundRadio() 
{
    m_Player1->SetOutputName("/dev/dsound/0");	
    m_Player2->SetOutputName("/dev/dsound/0");	
}

void CMfcPlayerDlg::OnUseWaveRadio() 
{
    m_Player1->SetOutputName("/dev/wave/0");	
    m_Player2->SetOutputName("/dev/wave/0");	
}

void CMfcPlayerDlg::OnFile1Button() 
{
	// open a file
	CFileDialog *dialog;

	dialog = new CFileDialog(TRUE, 
							"mp3",
							"",
							OFN_FILEMUSTEXIST    | 
							OFN_HIDEREADONLY     |
							OFN_EXPLORER,
							"MPEG Audio Files {*.mpg;*.mp1;*.mp2;*.mp3}|*.mpg;*.mp1;*.mp2;*.mp3|All Files {*.*}|*.*||");


	int ret;
	ret = dialog->DoModal();
	if (ret == IDOK) {
        // a file was selected
		m_Player1->InputOpen(dialog->GetPathName());
        m_Player1->Play();
	}

	delete dialog;
}

void CMfcPlayerDlg::OnFile2Button() 
{
	// open a file
	CFileDialog *dialog;

	dialog = new CFileDialog(TRUE, 
							"mp3",
							"",
							OFN_FILEMUSTEXIST    | 
							OFN_HIDEREADONLY     |
							OFN_EXPLORER,
							"MPEG Audio Files {*.mpg;*.mp1;*.mp2;*.mp3}|*.mpg;*.mp1;*.mp2;*.mp3|All Files {*.*}|*.*||");


	int ret;
	ret = dialog->DoModal();
	if (ret == IDOK) {
        // a file was selected
		m_Player2->InputOpen(dialog->GetPathName());
        m_Player2->Play();
	}

	delete dialog;
}

void CMfcPlayerDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
    if (pScrollBar->m_hWnd == m_PitchSlider1.m_hWnd) {
        if (nSBCode == SB_THUMBPOSITION ||
            nSBCode == SB_THUMBTRACK) {
            m_Player1->SetPlayerEnvironmentInteger("OUTPUT.DIRECTSOUND.PITCH", nPos);
        }
    } else if (pScrollBar->m_hWnd == m_PitchSlider2.m_hWnd) {
        if (nSBCode == SB_THUMBPOSITION ||
            nSBCode == SB_THUMBTRACK) {
            m_Player2->SetPlayerEnvironmentInteger("OUTPUT.DIRECTSOUND.PITCH", nPos);
        }
    } else if (pScrollBar->m_hWnd == m_VolumeSlider1.m_hWnd) {
        if (nSBCode == SB_THUMBPOSITION ||
            nSBCode == SB_THUMBTRACK) {
            m_Player1->SetOutputVolume(XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                       nPos,
                                       XA_OUTPUT_VOLUME_IGNORE_FIELD);
        }
    } else if (pScrollBar->m_hWnd == m_VolumeSlider2.m_hWnd) {
        if (nSBCode == SB_THUMBPOSITION ||
            nSBCode == SB_THUMBTRACK) {
            m_Player2->SetOutputVolume(XA_OUTPUT_VOLUME_IGNORE_FIELD,
                                       nPos,
                                       XA_OUTPUT_VOLUME_IGNORE_FIELD);
        }
    }

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

