#include <windows.h>
#include <stdio.h>
//---------------------------------------------------------------------------
//	TGA Ŭ
//	⼭ ϴ ̹  4Ʈ ̹ ,  Դϴ.
//---------------------------------------------------------------------------

class cTGA
{
public:
	DWORD			Width,Height;
	WORD			*pIMAGE;

					cTGA()	{pIMAGE	=	NULL;}
					~cTGA()	
					{	if (pIMAGE)
						{	delete [] pIMAGE;
							pIMAGE	=	NULL;
						}
					};

	BOOL			Load(char *fn);
	BOOL			Load(FILE *fp);
	BOOL			Put(int x,int y);

	static	BOOL	Save(char *fn,WORD *image,BOOL overWrite=TRUE);
};

#pragma pack(1)

struct TGA_HEADER_TYPE
{	char	idLength;
	char	ColorMapType;
	char	ImageType;
	WORD	ColorMapFirst;
	WORD	ColorMapLast;
	char	ColorMapBits;
	WORD	FirstX;
	WORD	FirstY;
	WORD	Width;
	WORD	Height;
	char	Bits;
	char	Descriptor;
}	TGA_HEADER;

#pragma pack()


BOOL
cTGA::Load(FILE *fp)
{	memset(&TGA_HEADER	,0,sizeof(TGA_HEADER));

	fread(&TGA_HEADER	,sizeof(TGA_HEADER),1,fp);

/*	MSGOUT("TGA_HEADER.idLength     ->%d",TGA_HEADER.idLength);
	MSGOUT("TGA_HEADER.ColorMapType ->%d",TGA_HEADER.ColorMapType);
	MSGOUT("TGA_HEADER.ImageType    ->%d",TGA_HEADER.ImageType);
	MSGOUT("TGA_HEADER.ColorMapFirst->%d",TGA_HEADER.ColorMapFirst);
	MSGOUT("TGA_HEADER.ColorMapLast ->%d",TGA_HEADER.ColorMapLast);
	MSGOUT("TGA_HEADER.ColorMapBits ->%d",TGA_HEADER.ColorMapBits);
	MSGOUT("TGA_HEADER.FirstX       ->%d",TGA_HEADER.FirstX);
	MSGOUT("TGA_HEADER.FirstY       ->%d",TGA_HEADER.FirstY);
	MSGOUT("TGA_HEADER.Width        ->%d",TGA_HEADER.Width);
	MSGOUT("TGA_HEADER.Height       ->%d",TGA_HEADER.Height);
	MSGOUT("TGA_HEADER.Bits         ->%d",TGA_HEADER.Bits);
	MSGOUT("TGA_HEADER.Descriptor   ->%d",TGA_HEADER.Descriptor);
*/
	if(TGA_HEADER.Bits != 16)	return FALSE;//MSGOUT("Error!! '%s' file not 16bit image");

	Width	=	TGA_HEADER.Width;
	Height	=	TGA_HEADER.Height;

	pIMAGE	=	new WORD[(Width * Height)+2];	//	̹ + 4Ʈ(,)
	pIMAGE[0]=	(WORD) Width;
	pIMAGE[1]=	(WORD) Height;

	for(int line = Height-1; line >=0; line--)	fread(pIMAGE+line*Width+2,Width*2,1,fp);

	return TRUE;
}

BOOL
cTGA::Load(char *fn)
{	FILE	*fp;
	fp	=	fopen(fn,"rb");

	if(fp == NULL) return FALSE;//MSGOUT("'%s' file not Found!!");

	BOOL result	=	Load(fp);

	fclose(fp);

	return result;
}

BOOL
cTGA::Put(int x,int y)
{	if (!pIMAGE) return FALSE;

//	cDRAW::PutImage(x,y,pIMAGE);
	return TRUE;
}

BOOL
cTGA::Save(char *fn,WORD *image,BOOL overWrite)
{//	if (!overWrite)	if (IsFile(fn)) return MSGOUT("Error in cTGA::Save - '%s' File Exist!",fn);

	if (!image	) return FALSE;//MSGOUT("Error in cTGA::Save - value 'image' are valid!!",fn);

	FILE *fp;
	fp	=	fopen(fn,"wb");

	if (!fp		) return FALSE;//MSGOUT("Error in cTGA::Save - '%s' file open(write) error!!",fn);

	int		xs	=	image[0];
	int		ys	=	image[1];

	TGA_HEADER.idLength     =0;
	TGA_HEADER.ColorMapType =0;
	TGA_HEADER.ImageType    =2;
	TGA_HEADER.ColorMapFirst=0;
	TGA_HEADER.ColorMapLast =0;
	TGA_HEADER.ColorMapBits =0;
	TGA_HEADER.FirstX       =0;
	TGA_HEADER.FirstY       =0;
	TGA_HEADER.Width        =xs;
	TGA_HEADER.Height       =ys;
	TGA_HEADER.Bits         =16;
	TGA_HEADER.Descriptor   =1;

	fwrite(&TGA_HEADER,sizeof(TGA_HEADER),1,fp);

	for(int line = ys-1; line >=0; line--)	fwrite(image+line*xs+2,xs*2,1,fp);

	fclose(fp);

	return TRUE;
}