#include "TOOL.h"
#include "cASMEApp.h"

#include "cASMEMapWindow.h"
#include "cASMETileWindow.h"
#include "cASMEMapThumbWindow.h"
#include "cTileWindow.h"

int cASMEApp::Run(int nCmdShow){
	int rv; 

	cTileWindow::RegisterClass();

	cASMEAppWindow::RegisterClass();
	cASMEMapWindow::RegisterClass();
	cASMETileWindow::RegisterClass();
	cASMEMapThumbWindow::RegisterClass();

	if(!TileMap.Create(10, 10))
		return false;
	if(!TileSet.Create())
		return false;
	TileMap.SetTileSet(&TileSet);

	if(!AppWindow.Create(WS_EX_LEFT, "AS Map Editor", WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, 
		0, 0, GetSystemMetrics(SM_CXFULLSCREEN), GetSystemMetrics(SM_CYFULLSCREEN),
		0, 0)){
		_ASSERTE(FALSE);
	}
	AppWindow.Show(nCmdShow);

	rv = MessageLoop();

	AppWindow.Destroy();

	TileMap.Destroy();
	TileSet.Destroy();

	return rv;

}

cASMEAppWindow *cASMEApp::GetAppWindow(){
	return &AppWindow;
}


cTileMap *cASMEApp::GetTileMap(){
	return &TileMap;
}
