#include "TOOL.h"
#include "cASMEAppWindow.h"
#include "cASMEApp.h"

#include "ASMapEditor.h"
#include "Resource.h"

#include "cDisplay.h"

#include "TOOLDebug.h"

#include "cASMEHelpDialog.h"
#include "cASMEAboutDialog.h"

cASMEAppWindow::cASMEAppWindow(){
}

cASMEAppWindow::~cASMEAppWindow(){

}

bool cASMEAppWindow::RegisterClass(){
	return cWindow::RegisterClass(
		"cASMEAppWindow", 
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		LoadIcon(App, MAKEINTRESOURCE(IDI_App)), 
		LoadCursor(0, IDC_ARROW),
		(HBRUSH)(COLOR_APPWORKSPACE + 1),
		MAKEINTRESOURCE(IDR_AppMenu));
	
}

LRESULT cASMEAppWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		if(!OnCreate(wParam, lParam))
			return -1;
		return 0;
	case WM_DESTROY:
		OnDestroy(wParam, lParam);
		break;
	case WM_CLOSE:
		if(OnClose(wParam, lParam)) return 0;
		break;
	case WM_SIZE:
	case WM_MOVE:
		OnSize(wParam, lParam);
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_KEYDOWN:
	case WM_KEYUP:
		OnKeyEvent(uMsg, wParam, lParam);
		return 0;
	case WM_MOUSEMOVE:
	case WM_LBUTTONDOWN:
	case WM_LBUTTONUP:
	case WM_LBUTTONDBLCLK:
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
	case WM_RBUTTONDBLCLK:
		OnMouseEvent(uMsg, wParam, lParam);
		return 0;

	case WM_COMMAND:
		OnCommand(wParam, lParam);
		return 0;
	}
	return DefProc(uMsg, wParam, lParam);
}


bool cASMEAppWindow::OnClose(WPARAM wParam, LPARAM lParam){
	return false;
}



// OnCreate ///////////////////////////////////////////////////////
bool cASMEAppWindow::OnCreate(WPARAM wParam, LPARAM lParam){
	Display.Create(hWnd);
	Display.SetCooperativeLevel(DDSCL_NORMAL);
	Display.CreateDoubleBuffer(
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN), false);

	if(!ToolDialog.Create(&App, MAKEINTRESOURCE(IDD_ToolBar), this))
		assert(false);
	ToolDialog.Show(SW_SHOW);

	OnViewNewMapView();
	if(!TileWindow.Create(WS_EX_LEFT, "Tile", 
		WS_CHILD | WS_POPUP | WS_CAPTION | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU | WS_THICKFRAME | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN,
		50, 400, 32 * 16 + 24, 32 * 3 + 8, this))
		assert(false);
	ThumbWindow.SetTileMap(App.GetTileMap());
	if(!ThumbWindow.Create(WS_EX_LEFT, "Thumb",
		WS_CHILD | WS_POPUP | WS_CAPTION | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU | WS_THICKFRAME | WS_VISIBLE | WS_CLIPSIBLINGS,
		460, 60, 100, 100, this))
		assert(false);

	TileWindow.GetTileWindow()->SetTileSet(App.GetTileMap()->GetTileSet());
//	TileWindow.LoadTile("
	return true;
}

void cASMEAppWindow::OnDestroy(WPARAM wParam, LPARAM lParam){
	cASMEMapWindowList::cCursor csr;

	ThumbWindow.Destroy();
	TileWindow.Destroy();

	for(csr = MapWindowList.Head(); csr != 0; csr ++){
		(*csr)->Destroy();
		delete *csr;
	}
	MapWindowList.Clear();

	ToolDialog.Destroy();

	Display.DestroyDoubleBuffer();
	Display.Destroy();

	PostQuitMessage(0);
}


// OnSize ///////////////////////////////////////////////////////
void cASMEAppWindow::OnSize(WPARAM wParam, LPARAM lParam){
}

// OnPaint ///////////////////////////////////////////////////////
void cASMEAppWindow::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	
	BeginPaint(&ps);
	EndPaint(&ps);

}


// Mouse Handlers //////////////////////////////////////////////////
void cASMEAppWindow::OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}


void cASMEAppWindow::OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMEAppWindow::OnCommand(WPARAM wParam, LPARAM lParam){
	if(HIWORD(wParam) == 0){ // From Menu
		switch(LOWORD(wParam)){
		case IDM_FileExit:
			PostQuitMessage(0);
			break;
		case IDM_ViewNewMapView:
			OnViewNewMapView();
			break;
		case IDM_HelpHelp:
			OnHelpHelp();
			break;
		case IDM_HelpAbout:
			OnHelpAbout();
			break;

		}
	}
}



void cASMEAppWindow::OnViewNewMapView(){
	cASMEMapWindow *pWindow;

	pWindow = new cASMEMapWindow;
	pWindow->SetTileMap(App.GetTileMap());
	if(!pWindow->Create(WS_EX_LEFT, "Map", 
		WS_CHILD | WS_POPUP | WS_CAPTION | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU | WS_THICKFRAME | WS_VISIBLE | WS_CLIPSIBLINGS | WS_VSCROLL | WS_HSCROLL,
		32, 64, 400, 300, this))
		assert(false);

	MapWindowList.AddTail(pWindow);

}



void cASMEAppWindow::OnHelpHelp(){
	cASMEHelpDialog dlg;
	dlg.DoModal(&App, MAKEINTRESOURCE(IDD_Help), this);
}

void cASMEAppWindow::OnHelpAbout(){
	cASMEAboutDialog dlg;

	dlg.DoModal(&App, MAKEINTRESOURCE(IDD_About), this);

}

cASMETileWindow *cASMEAppWindow::GetTileWindow(){
	return &TileWindow;
}

cASMEMapThumbWindow *cASMEAppWindow::GetThumbWindow(){
	return &ThumbWindow;
}

cASMEToolDialog *cASMEAppWindow::GetToolDialog(){
	return &ToolDialog;
}

void cASMEAppWindow::UpdateAllMapWindows(){
	cASMEMapWindowList::cCursor csr;

	for(csr = MapWindowList.Head(); csr != 0; csr ++){
		(*csr)->Invalidate();
		(*csr)->RecalcScrollBars();
	}

}

void cASMEAppWindow::OnCloseMapWindow(cASMEMapWindow *pWindow){
	MapWindowList.Remove(pWindow);
}
