#ifndef cASMEAppWindow_H
#define cASMEAppWindow_H

#include "cWindow.h"
#include "cASMEMapWindow.h"
#include "cASMETileWindow.h"
#include "cASMEMapThumbWindow.h"
#include "cASMEToolDialog.h"
#include "cList.h"

typedef cList<cASMEMapWindow *> cASMEMapWindowList;

class cASMEAppWindow : public cWindow{
protected:
	// ڽ   .
	cASMEMapWindowList MapWindowList;
	cASMETileWindow TileWindow;
	cASMEMapThumbWindow ThumbWindow;
	cASMEToolDialog ToolDialog;


	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual char *GetClassName(){ return "cASMEAppWindow"; }

	// Message Handlers
	bool OnClose(WPARAM wParam, LPARAM lParam);
	bool OnCreate(WPARAM wParam, LPARAM lParam);
	void OnDestroy(WPARAM wParam, LPARAM lParam);
	void OnSize(WPARAM wParam, LPARAM lParam);
	void OnPaint(WPARAM wParam, LPARAM lParam);
	void OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnCommand(WPARAM wParam, LPARAM lParam);

	// Menu Handlers
	void OnViewNewMapView();
	void OnHelpHelp();
	void OnHelpAbout();

public:
	cASMEAppWindow();
	virtual ~cASMEAppWindow();
	static bool RegisterClass();

	cASMETileWindow *GetTileWindow();
	cASMEMapThumbWindow *GetThumbWindow();
	cASMEToolDialog *GetToolDialog();

	void UpdateAllMapWindows();
	void OnCloseMapWindow(cASMEMapWindow *pWindow);

};

#endif
