#include "TOOL.h"
#include "cASMEDrawBoxWindow.h"

#include "cDisplay.h"
#include "ASMapEditor.h"

cASMEDrawBoxWindow::cASMEDrawBoxWindow(){
}

cASMEDrawBoxWindow::~cASMEDrawBoxWindow(){

}

bool cASMEDrawBoxWindow::RegisterClass(){
	return cWindow::RegisterClass(
		"cASMEDrawBoxWindow", 
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, 
		LoadCursor(0, IDC_ARROW),
		(HBRUSH)GetStockObject(WHITE_BRUSH));
	
}

LRESULT cASMEDrawBoxWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		if(!OnCreate(wParam, lParam))
			return -1;
		return 0;
	case WM_DESTROY:
		OnDestroy(wParam, lParam);
		break;
	case WM_CLOSE:
		if(OnClose(wParam, lParam)) return 0;
		break;
	case WM_SIZE:
	case WM_MOVE:
		OnSize(wParam, lParam);
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_ERASEBKGND:
		return 1;
	case WM_KEYDOWN:
	case WM_KEYUP:
		OnKeyEvent(uMsg, wParam, lParam);
		return 0;
	case WM_MOUSEMOVE:
		OnMouseMove(wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
		return 0;
	case WM_LBUTTONUP:
	case WM_LBUTTONDBLCLK:
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
	case WM_RBUTTONDBLCLK:
		OnMouseEvent(uMsg, wParam, lParam);
		return 0;
	case WM_HSCROLL:
		OnHScroll(wParam, lParam);
		return 0;
	case WM_VSCROLL:
		OnVScroll(wParam, lParam);
		return 0;


	}
	return DefProc(uMsg, wParam, lParam);
}


bool cASMEDrawBoxWindow::OnClose(WPARAM wParam, LPARAM lParam){
	return true;
}



// OnCreate ///////////////////////////////////////////////////////
bool cASMEDrawBoxWindow::OnCreate(WPARAM wParam, LPARAM lParam){
	if(!TileMap.Create(10, 10))
		return false;
	Clipper.Create(hWnd);

	return true;
}

void cASMEDrawBoxWindow::OnDestroy(WPARAM wParam, LPARAM lParam){
	Clipper.Destroy();
	TileMap.Destroy();
}


// OnSize ///////////////////////////////////////////////////////
void cASMEDrawBoxWindow::OnSize(WPARAM wParam, LPARAM lParam){
	RecalcScrollBars();
}

// OnPaint ///////////////////////////////////////////////////////
void cASMEDrawBoxWindow::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
/*	cRect ClientRect;
	cRect ScreenRect;
	cRect SrcRect;
	int OrgX;
	int OrgY;
	int MapX;
	int MapY;
	int SelectedTileID;
*/	
	BeginPaint(&ps);
	EndPaint(&ps);
/*
	GetClientRect(ClientRect);
	ScreenRect = ClientRect;
	ClientToScreen(ScreenRect);

	Display.GetBackPic()->ClearRect(&ScreenRect);
	if(TileMap.GetTileSet()->GetTileCount()){

		OrgX = GetScrollPos(SB_HORZ);
		OrgY = GetScrollPos(SB_VERT);

		SrcRect.left = OrgX * TileMap.GetTileSet()->GetTileWidth();
		SrcRect.top = OrgY * TileMap.GetTileSet()->GetTileHeight();
		SrcRect.right = SrcRect.left + ClientRect.Width();
		SrcRect.bottom = SrcRect.top + ClientRect.Height();

		TileMap.ShowMap(Display.GetBackPic(), 
			ScreenRect.left, ScreenRect.top,
			&SrcRect, true);
		//  Ÿ  ׸.
		SelectedTileID = App.GetAppWindow()->GetTileWindow()->GetSelectedTileID();
		if(SelectedTileID >= 0){
			MapX = OrgX + MousePos.x / TileMap.GetTileSet()->GetTileWidth();
			MapY = OrgY + MousePos.y / TileMap.GetTileSet()->GetTileHeight();

			if(MapX >= 0 && MapX < TileMap.GetWidth() &&
				MapY >= 0 && MapY < TileMap.GetHeight()){
				Display.GetBackPic()->BlendedBlt(
					ScreenRect.left + (MapX - OrgX) * TileMap.GetTileSet()->GetTileWidth(),
					ScreenRect.top + (MapY - OrgY) * TileMap.GetTileSet()->GetTileHeight(),
					&TileMap.GetTile(SelectedTileID)->UnderPicture,
					0, PBE_LIGHT_COPY);

			}
		}

	}

	Display.GetFrontPic()->SetClipper(&Clipper);
	Display.GetFrontPic()->Blt(&ScreenRect, Display.GetBackPic(), &ScreenRect);
	Display.GetFrontPic()->SetClipper(0);
*/
}


// Mouse Handlers //////////////////////////////////////////////////
void cASMEDrawBoxWindow::OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMEDrawBoxWindow::OnMouseMove(WPARAM wParam, LPARAM lParam){
	// Ÿ Ѵ.
	MousePos.x = LOWORD(lParam);
	MousePos.y = HIWORD(lParam);

	if(wParam & MK_LBUTTON){
		SetTile();
	}
	Invalidate();
	
}

void cASMEDrawBoxWindow::OnLButtonDown(WPARAM wParam, LPARAM lParam){
	SetTile();
}


void cASMEDrawBoxWindow::OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}




cTileMap *cASMEDrawBoxWindow::GetMap(){
	return &TileMap;
}

bool cASMEDrawBoxWindow::LoadMap(LPCTSTR FileName){
	return false;
}

void cASMEDrawBoxWindow::RecalcScrollBars(){
	SCROLLINFO si;
	cRect ClientRect;

	if(TileMap.GetTileSet()->GetTileCount()){
		GetClientRect(ClientRect);

		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = TileMap.GetHeight();
		si.nPage = ClientRect.bottom / TileMap.GetTileSet()->GetTileWidth();
		SetScrollInfo(SB_HORZ, &si);

		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = TileMap.GetWidth();
		si.nPage = ClientRect.bottom / TileMap.GetTileSet()->GetTileHeight();
		SetScrollInfo(SB_VERT, &si);
	}
}

void cASMEDrawBoxWindow::SetTile(){
/*	int OrgX;
	int OrgY;
	int MapX;
	int MapY;
	int SelectedTileID;

	SelectedTileID = App.GetAppWindow()->GetTileWindow()->GetSelectedTileID();
	if(SelectedTileID < 0)
		return;

	OrgX = GetScrollPos(SB_HORZ);
	OrgY = GetScrollPos(SB_VERT);

	MapX = OrgX + MousePos.x / TileMap.GetTileSet()->GetTileWidth();
	MapY = OrgY + MousePos.y / TileMap.GetTileSet()->GetTileHeight();

	if(MapX >= 0 && MapX < TileMap.GetWidth() &&
		MapY >= 0 && MapY < TileMap.GetHeight()){
		TileMap.SetTile(MapY, MapX, SelectedTileID);
		Invalidate();
	}*/
}
