#include "TOOL.h"
#include "cASMEMapResizeDialog.h"

#include "TOOLDebug.h"
#include "Resource.h"

#include "cSpot.h"

cASMEMapResizeDialog::cASMEMapResizeDialog(){
	MapWidth = 256;
	MapHeight = 256;
}

cASMEMapResizeDialog::~cASMEMapResizeDialog(){

}

BOOL cASMEMapResizeDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_INITDIALOG:
		SetDlgItemInt(IDC_MapWidth, MapWidth);
		SetDlgItemInt(IDC_MapHeight, MapHeight);
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDOK:
			MapWidth = GetDlgItemInt(IDC_MapWidth);
			MapHeight = GetDlgItemInt(IDC_MapHeight);
			EndDialog(LOWORD(wParam));
			return TRUE;

		case IDCANCEL:
			EndDialog(LOWORD(wParam));
			return TRUE;

		case IDC_MapWidth:
			switch(HIWORD(wParam)){
			case EN_CHANGE:
				SetDlgItemInt(IDC_PixelWidth, GetDlgItemInt(IDC_MapWidth) * 32);
				SetDlgItemInt(IDC_MemorySize, GetDlgItemInt(IDC_MapWidth) * GetDlgItemInt(IDC_MapHeight) * sizeof(cSpot));
				break;
			}
			break;

		case IDC_MapHeight:
			switch(HIWORD(wParam)){
			case EN_CHANGE:
				SetDlgItemInt(IDC_PixelHeight, GetDlgItemInt(IDC_MapHeight) * 32);
				SetDlgItemInt(IDC_MemorySize, GetDlgItemInt(IDC_MapWidth) * GetDlgItemInt(IDC_MapHeight) * sizeof(cSpot));
				break;

			}
			break;
		}


	}
    return FALSE; 
}

