#include "TOOL.h"
#include "cASMEMapThumbWindow.h"

#include "cDisplay.h"
#include "ASMapEditor.h"

cASMEMapThumbWindow::cASMEMapThumbWindow(){
}

cASMEMapThumbWindow::~cASMEMapThumbWindow(){

}

bool cASMEMapThumbWindow::RegisterClass(){
	return cWindow::RegisterClass(
		"cASMEMapThumbWindow", 
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, 
		LoadCursor(0, IDC_ARROW),
		(HBRUSH)GetStockObject(WHITE_BRUSH));
	
}

LRESULT cASMEMapThumbWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		if(!OnCreate(wParam, lParam))
			return -1;
		return 0;
	case WM_DESTROY:
		OnDestroy(wParam, lParam);
		break;
	case WM_CLOSE:
		if(OnClose(wParam, lParam)) return 0;
		break;
	case WM_SIZE:
	case WM_MOVE:
		OnSize(wParam, lParam);
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_ERASEBKGND:
		return 1;
	case WM_KEYDOWN:
	case WM_KEYUP:
		OnKeyEvent(uMsg, wParam, lParam);
		return 0;
	case WM_MOUSEMOVE:
		OnMouseMove(wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
		return 0;
	case WM_LBUTTONUP:
	case WM_LBUTTONDBLCLK:
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
	case WM_RBUTTONDBLCLK:
		OnMouseEvent(uMsg, wParam, lParam);
		return 0;
	case WM_HSCROLL:
		OnHScroll(wParam, lParam);
		return 0;
	case WM_VSCROLL:
		OnVScroll(wParam, lParam);
		return 0;


	}
	return DefProc(uMsg, wParam, lParam);
}


bool cASMEMapThumbWindow::OnClose(WPARAM wParam, LPARAM lParam){
	return true;
}



// OnCreate ///////////////////////////////////////////////////////
bool cASMEMapThumbWindow::OnCreate(WPARAM wParam, LPARAM lParam){
	Clipper.Create(hWnd);

	return true;
}

void cASMEMapThumbWindow::OnDestroy(WPARAM wParam, LPARAM lParam){
	Clipper.Destroy();
}


// OnSize ///////////////////////////////////////////////////////
void cASMEMapThumbWindow::OnSize(WPARAM wParam, LPARAM lParam){
	RecalcScrollBars();
}

// OnPaint ///////////////////////////////////////////////////////
void cASMEMapThumbWindow::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	cRect ClientRect;
	cRect ScreenRect;
	cRect SrcRect;
	int OrgX;
	int OrgY;
	int MapX;
	int MapY;
	int x, y;
	cRect DestRect;
	
	BeginPaint(&ps);
	EndPaint(&ps);

	GetClientRect(ClientRect);
	ScreenRect = ClientRect;
	ClientToScreen(ScreenRect);

	Display.GetBackPic()->ClearRect(&ScreenRect);
	if(pTileMap->GetTileSet()->GetTileCount()){

		OrgX = GetScrollPos(SB_HORZ);
		OrgY = GetScrollPos(SB_VERT);

		SrcRect.left = 0;
		SrcRect.top = 0;
		SrcRect.right = 2;
		SrcRect.bottom = 2;

		for(y = 0; y < ClientRect.Height(); y ++){
			MapY = OrgY + y;
			for(x = 0; x < ClientRect.Width(); x ++){
				MapX = OrgX + x;
				if(MapX >= 0 && MapX < pTileMap->GetWidth() &&
					MapY >= 0 && MapY < pTileMap->GetHeight()){
					DestRect.Set(ScreenRect.left + x, ScreenRect.top + y,
						ScreenRect.left + x + 2, ScreenRect.top + y + 2);
					Display.GetBackPic()->Blt(
						DestRect, &pTileMap->GetTile(MapY, MapX)->UnderPicture,
						SrcRect);
				}
			}
		}
	}

	Display.GetFrontPic()->SetClipper(&Clipper);
	Display.GetFrontPic()->Blt(&ScreenRect, Display.GetBackPic(), &ScreenRect);
	Display.GetFrontPic()->SetClipper(0);

}


// Mouse Handlers //////////////////////////////////////////////////
void cASMEMapThumbWindow::OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMEMapThumbWindow::OnMouseMove(WPARAM wParam, LPARAM lParam){
}

void cASMEMapThumbWindow::OnLButtonDown(WPARAM wParam, LPARAM lParam){
}


void cASMEMapThumbWindow::OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMEMapThumbWindow::RecalcScrollBars(){
	SCROLLINFO si;
	cRect ClientRect;

	if(pTileMap->GetTileSet()->GetTileCount()){
		GetClientRect(ClientRect);

		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = pTileMap->GetHeight();
		si.nPage = ClientRect.bottom;
		SetScrollInfo(SB_HORZ, &si);

		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = pTileMap->GetWidth();
		si.nPage = ClientRect.bottom;
		SetScrollInfo(SB_VERT, &si);
	}
}


void cASMEMapThumbWindow::SetTileMap(cTileMap *_pTileMap){
	pTileMap = _pTileMap;
}
