#ifndef cASMEMapThumbWindow_H
#define cASMEMapThumbWindow_H

#include "cWindow.h"
#include "cClipper.h"

#include "cTileMap.h"


class cASMEMapThumbWindow : public cWindow{
protected:
	// ڽ   .
	cTileMap *pTileMap;

	cClipper Clipper;

	cPoint MousePos;


	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual char *GetClassName(){ return "cASMEMapThumbWindow"; }

	// Message Handlers
	bool OnClose(WPARAM wParam, LPARAM lParam);
	bool OnCreate(WPARAM wParam, LPARAM lParam);
	void OnDestroy(WPARAM wParam, LPARAM lParam);
	void OnSize(WPARAM wParam, LPARAM lParam);
	void OnPaint(WPARAM wParam, LPARAM lParam);
	void OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);


	void SetTile();

public:
	cASMEMapThumbWindow();
	virtual ~cASMEMapThumbWindow();
	static bool RegisterClass();

	cTileMap *GetMap();

	bool LoadMap(LPCTSTR FileName);
	bool SaveMap(LPCTSTR FileName);
	void RecalcScrollBars();

	void SetTileMap(cTileMap *_pTileMap);
};

#endif
