#include "TOOL.h"
#include "cASMEMapWindow.h"

#include "cDisplay.h"
#include "ASMapEditor.h"
#include "Resource.h"
#include "cASMEMapResizeDialog.h"

cASMEMapWindow::cASMEMapWindow(){
}

cASMEMapWindow::~cASMEMapWindow(){

}

bool cASMEMapWindow::RegisterClass(){
	return cWindow::RegisterClass(
		"cASMEMapWindow", 
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, 
		LoadCursor(0, IDC_ARROW),
		(HBRUSH)GetStockObject(WHITE_BRUSH),
		MAKEINTRESOURCE(IDR_MapMenu));
	
}

LRESULT cASMEMapWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		if(!OnCreate(wParam, lParam))
			return -1;
		return 0;
	case WM_DESTROY:
		OnDestroy(wParam, lParam);
		break;
	case WM_CLOSE:
		if(OnClose(wParam, lParam)) return 0;
		break;
	case WM_SIZE:
	case WM_MOVE:
		OnSize(wParam, lParam);
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_ERASEBKGND:
		return 1;
	case WM_KEYDOWN:
	case WM_KEYUP:
		OnKeyEvent(uMsg, wParam, lParam);
		return 0;
	case WM_MOUSEMOVE:
		OnMouseMove(wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
		return 0;
	case WM_LBUTTONUP:
		OnLButtonUp(wParam, lParam);
		return 0;
	case WM_HSCROLL:
		OnHScroll(wParam, lParam);
		return 0;
	case WM_VSCROLL:
		OnVScroll(wParam, lParam);
		return 0;
	case WM_COMMAND:
		OnCommand(wParam, lParam);
		return 0;
	}
	return DefProc(uMsg, wParam, lParam);
}


bool cASMEMapWindow::OnClose(WPARAM wParam, LPARAM lParam){
	((cASMEAppWindow*)GetParent())->OnCloseMapWindow(this);
	return false;
}



// OnCreate ///////////////////////////////////////////////////////
bool cASMEMapWindow::OnCreate(WPARAM wParam, LPARAM lParam){
	Clipper.Create(hWnd);

	Dragging = false;
	return true;
}

void cASMEMapWindow::OnDestroy(WPARAM wParam, LPARAM lParam){
	Clipper.Destroy();
}


// OnSize ///////////////////////////////////////////////////////
void cASMEMapWindow::OnSize(WPARAM wParam, LPARAM lParam){
	RecalcScrollBars();
}

// OnPaint ///////////////////////////////////////////////////////
void cASMEMapWindow::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	cRect ClientRect;
	cRect ScreenRect;
	cRect SrcRect;
	int OrgX;
	int OrgY;
	int MapOrgX, MapOrgY;
	int MapX;
	int MapY;
	int TileID;
	int x, y;
	cRect SelRect;

	
	BeginPaint(&ps);
	EndPaint(&ps);

	GetClientRect(ClientRect);
	ScreenRect = ClientRect;
	ClientToScreen(ScreenRect);

	Display.GetBackPic()->ClearRect(&ScreenRect);
	if(pTileMap->GetTileSet()->GetTileCount()){

		OrgX = GetScrollPos(SB_HORZ);
		OrgY = GetScrollPos(SB_VERT);

		SrcRect.left = OrgX * pTileMap->GetTileSet()->GetTileWidth();
		SrcRect.top = OrgY * pTileMap->GetTileSet()->GetTileHeight();
		SrcRect.right = SrcRect.left + ClientRect.Width();
		SrcRect.bottom = SrcRect.top + ClientRect.Height();

		pTileMap->ShowMap(Display.GetBackPic(), 
			ScreenRect.left, ScreenRect.top,
			&SrcRect, true);

		//  Ÿ  ׸.
		SelRect = App.GetAppWindow()->GetTileWindow()->GetTileWindow()->GetTileRect();

		MapOrgX = OrgX + MousePos.x / pTileMap->GetTileSet()->GetTileWidth();
		MapOrgY = OrgY + MousePos.y / pTileMap->GetTileSet()->GetTileHeight();
		for(y = 0; y < SelRect.Height(); y ++){
			MapY = MapOrgY + y - SelRect.Height() / 2;;
			for(x = 0; x < SelRect.Width(); x ++){
				MapX = MapOrgX + x - SelRect.Width() / 2;
				TileID = (SelRect.top + y) * 16 + SelRect.left + x;
				if(TileID >= 0 && TileID < pTileMap->GetTileSet()->GetTileCount()){
					if(MapX >= 0 && MapX < pTileMap->GetWidth() &&
						MapY >= 0 && MapY < pTileMap->GetHeight()){
						Display.GetBackPic()->BlendedBlt(
							ScreenRect.left + (MapX - OrgX) * pTileMap->GetTileSet()->GetTileWidth(),
							ScreenRect.top + (MapY - OrgY) * pTileMap->GetTileSet()->GetTileHeight(),
							&pTileMap->GetTile(TileID)->UnderPicture, 0,
							PBE_LIGHT_COPY);
						
					}else{
						Display.GetBackPic()->BlendedBlt(
							ScreenRect.left + (MapX - OrgX) * pTileMap->GetTileSet()->GetTileWidth(),
							ScreenRect.top + (MapY - OrgY) * pTileMap->GetTileSet()->GetTileHeight(),
							&pTileMap->GetTile(TileID)->UnderPicture, 0,
							PBE_Red);
					}
				}
			}
		}

	}

	Display.GetFrontPic()->SetClipper(&Clipper);
	Display.GetFrontPic()->Blt(&ScreenRect, Display.GetBackPic(), &ScreenRect);
	Display.GetFrontPic()->SetClipper(0);

}


// Mouse Handlers //////////////////////////////////////////////////
void cASMEMapWindow::OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMEMapWindow::OnMouseMove(WPARAM wParam, LPARAM lParam){
	// Ÿ Ѵ.
	MousePos.x = LOWORD(lParam);
	MousePos.y = HIWORD(lParam);

	if(Dragging){
		SetTile();
	}
	Invalidate();
	
}

void cASMEMapWindow::OnLButtonDown(WPARAM wParam, LPARAM lParam){
	Dragging = true;
	SetCapture();
	SetTile();
}

void cASMEMapWindow::OnLButtonUp(WPARAM wParam, LPARAM lParam){
	Dragging = false;
	ReleaseCapture();
	App.GetAppWindow()->GetThumbWindow()->Invalidate();
}


void cASMEMapWindow::OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMEMapWindow::OnCommand(WPARAM wParam, LPARAM lParam){
	if(HIWORD(wParam) == 0){ // From Menu
		switch(LOWORD(wParam)){
		case IDM_MapResize:
			OnMapResize();
			break;
		case IDM_MapLoad:
			OnMapLoad();
			break;
		case IDM_MapSave:
			OnMapSave();
			break;

		}
	}
}

void cASMEMapWindow::OnMapResize(){
	cASMEMapResizeDialog dlg;

	dlg.MapWidth = App.GetTileMap()->GetWidth();
	dlg.MapHeight = App.GetTileMap()->GetHeight();

	int n;

	if((n = dlg.DoModal(&App, MAKEINTRESOURCE(IDD_ResizeMap), this)) == IDOK){
		if(!App.GetTileMap()->Resize(dlg.MapWidth, dlg.MapHeight)){
			MessageBox("Map cannot be resized.", "Error");
		}
	}
}

void cASMEMapWindow::OnMapLoad(){
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260] = "*.map";       // buffer for file name

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Files(*.*)\0*.*\0AS Map File(*.map)\0*.map\0";
	ofn.nFilterIndex = 2;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrDefExt = "td";
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	// Display the Open dialog box. 
	if (GetOpenFileName(&ofn)){
		if(LoadMap(szFile)){
			RecalcScrollBars();
		}else{
			MessageBox("Map could not loaded.", "Error");
		}
	}
}

void cASMEMapWindow::OnMapSave(){
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260] = "*.map";       // buffer for file name

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Files(*.*)\0*.*\0AS Map File(*.map)\0*.map\0";
	ofn.nFilterIndex = 2;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrDefExt = "map";
	ofn.Flags = OFN_PATHMUSTEXIST;

	// Display the Open dialog box. 
	if (GetSaveFileName(&ofn)){
		if(!SaveMap(szFile)){
			MessageBox("Map Descripter could not saved.", "Error");
		}
	}
}

void cASMEMapWindow::SetTileMap(cTileMap *_pTileMap){
	pTileMap = _pTileMap;
}


cTileMap *cASMEMapWindow::GetMap(){
	return pTileMap;
}

bool cASMEMapWindow::LoadMap(LPCTSTR FileName){
	cMedium Medium;

	Medium.SetFileName(FileName);
	if(!Medium.Open(cMedium::OM_READ))
		return false;
	pTileMap->Destroy();
	if(!pTileMap->Load(&Medium)){
		Medium.Close();
		pTileMap->Create(10, 10);
		return false;
	}
	Medium.Close();

	return true;
}

bool cASMEMapWindow::SaveMap(LPCTSTR FileName){
	cMedium Medium;

	Medium.SetFileName(FileName);
	if(!Medium.Open(cMedium::OM_WRITE))
		return false;
	if(!pTileMap->Save(&Medium)){
		Medium.Close();
		return false;
	}
	Medium.Close();

	return true;
}

void cASMEMapWindow::RecalcScrollBars(){
	SCROLLINFO si;
	cRect ClientRect;

	if(pTileMap->GetTileSet()->GetTileCount()){
		GetClientRect(ClientRect);

		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = pTileMap->GetHeight();
		si.nPage = ClientRect.bottom / pTileMap->GetTileSet()->GetTileWidth();
		SetScrollInfo(SB_HORZ, &si);

		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = pTileMap->GetWidth();
		si.nPage = ClientRect.bottom / pTileMap->GetTileSet()->GetTileHeight();
		SetScrollInfo(SB_VERT, &si);
	}
}

void cASMEMapWindow::SetTile(){
	int OrgX;
	int OrgY;
	int MapOrgX, MapOrgY;
	int MapX;
	int MapY;
	int x, y;
	cRect SelRect;
	int TileID;

	if(pTileMap->GetTileSet()->GetTileCount() <= 0)
		return;

	SelRect = App.GetAppWindow()->GetTileWindow()->GetTileWindow()->GetTileRect();

	OrgX = GetScrollPos(SB_HORZ);
	OrgY = GetScrollPos(SB_VERT);

	MapOrgX = OrgX + MousePos.x / pTileMap->GetTileSet()->GetTileWidth();
	MapOrgY = OrgY + MousePos.y / pTileMap->GetTileSet()->GetTileHeight();

	for(y = 0; y < SelRect.Height(); y ++){
		MapY = MapOrgY + y - SelRect.Height() / 2;
		for(x = 0; x < SelRect.Width(); x ++){
			MapX = MapOrgX + x - SelRect.Width() / 2;
			TileID = (SelRect.top + y) * 16 + SelRect.left + x;
			if(TileID < 0 || TileID >= pTileMap->GetTileSet()->GetTileCount())
				continue;
		
			if(MapX >= 0 && MapX < pTileMap->GetWidth() &&
				MapY >= 0 && MapY < pTileMap->GetHeight()){
				pTileMap->SetTile(MapY, MapX, TileID);
			}
		}
	}

	Invalidate();

}
