#ifndef cASMEMapWindow_H
#define cASMEMapWindow_H

#include "cWindow.h"
#include "cClipper.h"

#include "cTileMap.h"


class cASMEMapWindow : public cWindow{
protected:
	// ڽ   .
	cTileMap *pTileMap;

	cClipper Clipper;

	cPoint MousePos;
	bool Dragging;

	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual char *GetClassName(){ return "cASMEMapWindow"; }

	// Message Handlers
	bool OnClose(WPARAM wParam, LPARAM lParam);
	bool OnCreate(WPARAM wParam, LPARAM lParam);
	void OnDestroy(WPARAM wParam, LPARAM lParam);
	void OnSize(WPARAM wParam, LPARAM lParam);
	void OnPaint(WPARAM wParam, LPARAM lParam);
	void OnMouseEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnCommand(WPARAM wParam, LPARAM lParam);

	void OnMapResize();
	void OnMapLoad();
	void OnMapSave();
	
	void SetTile();

public:
	cASMEMapWindow();
	virtual ~cASMEMapWindow();
	static bool RegisterClass();

	void SetTileMap(cTileMap *_pTileMap);
	cTileMap *GetMap();

	bool LoadMap(LPCTSTR FileName);
	bool SaveMap(LPCTSTR FileName);
	void RecalcScrollBars();

};

#endif
