#include "TOOL.h"
#include "cASMETileWindow.h"

#include "cDisplay.h"

#include "TOOLDebug.h"

#include "Resource.h"
#include "cASMEappWindow.h"

cASMETileWindow::cASMETileWindow(){
}

cASMETileWindow::~cASMETileWindow(){

}

bool cASMETileWindow::RegisterClass(){
	return cWindow::RegisterClass(
		"cASMETileWindow", 
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, 
		LoadCursor(0, IDC_ARROW),
		(HBRUSH)(COLOR_BTNFACE + 1),
		MAKEINTRESOURCE(IDR_TileMenu));
	
}

LRESULT cASMETileWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		if(!OnCreate(wParam, lParam))
			return -1;
		return 0;
	case WM_DESTROY:
		OnDestroy(wParam, lParam);
		break;
	case WM_CLOSE:
		if(OnClose(wParam, lParam)) return 0;
		break;
	case WM_SIZE:
		OnSize(wParam, lParam);
		return 0;
	case WM_MOVE:
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_KEYDOWN:
	case WM_KEYUP:
		OnKeyEvent(uMsg, wParam, lParam);
		return 0;
	case WM_MOUSEMOVE:
		OnMouseMove(wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
		return 0;
	case WM_LBUTTONUP:
		OnLButtonUp(wParam, lParam);
		return 0;
	case WM_LBUTTONDBLCLK:
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
	case WM_RBUTTONDBLCLK:
		return 0;
	case WM_HSCROLL:
		OnHScroll(wParam, lParam);
		return 0;
	case WM_VSCROLL:
		OnVScroll(wParam, lParam);
		return 0;

	case WM_COMMAND:
		OnCommand(wParam, lParam);
		return 0;


	}
	return DefProc(uMsg, wParam, lParam);
}


bool cASMETileWindow::OnClose(WPARAM wParam, LPARAM lParam){
	return true;
}



// OnCreate ///////////////////////////////////////////////////////
bool cASMETileWindow::OnCreate(WPARAM wParam, LPARAM lParam){
	cRect ClientRect;

	GetClientRect(ClientRect);

	if(!TileWindow.Create(WS_EX_LEFT, NULL, 
		WS_CHILD | WS_OVERLAPPED | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL,
		0, 0, 10, 10, this))
		assert(false);
	if(!BitmapList.Create(WS_EX_LEFT, NULL, 
		WS_CHILD | WS_OVERLAPPED | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL | LBS_NOTIFY,
		0, 0, 10, 10, this, 0))
		assert(false);

	return true;
}

void cASMETileWindow::OnDestroy(WPARAM wParam, LPARAM lParam){
	TileWindow.Destroy();
}


// OnSize ///////////////////////////////////////////////////////
void cASMETileWindow::OnSize(WPARAM wParam, LPARAM lParam){
	int cx, cy;

	cx = LOWORD(lParam);
	cy = HIWORD(lParam);

	BitmapList.Move(0, 0, 120, cy);
	TileWindow.Move(124, 0, cx - 124, cy, true);
}

// OnPaint ///////////////////////////////////////////////////////
void cASMETileWindow::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	
	BeginPaint(&ps);
	EndPaint(&ps);

}


// Mouse Handlers //////////////////////////////////////////////////
void cASMETileWindow::OnMouseMove(WPARAM wParam, LPARAM lParam){
}

void cASMETileWindow::OnLButtonDown(WPARAM wParam, LPARAM lParam){
}

void cASMETileWindow::OnLButtonUp(WPARAM wParam, LPARAM lParam){
}

void cASMETileWindow::OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}

void cASMETileWindow::OnCommand(WPARAM wParam, LPARAM lParam){
	if(HIWORD(wParam) == 0){ // From Menu
		switch(LOWORD(wParam)){
		case IDM_BitmapInsertBefore:
			OnBitmapInsertBefore();
			break;
		case IDM_BitmapInsertAfter:
			OnBitmapInsertAfter();
			break;
		case IDM_BitmapDelete:
			OnBitmapDelete();
			break;
		case IDM_BitmapMoveUp:
			OnBitmapMoveUp();
			break;
		case IDM_BitmapMoveDown:
			OnBitmapMoveDown();
			break;
		case IDM_TileNew:
			OnTileNew();
			break;
		case IDM_TileLoad:
			OnTileLoad();
			break;
		case IDM_TileSave:
			OnTileSave();
			break;
		case IDM_ViewTileProperty:
			OnViewTileProperty();
			break;
		}
	}
}

void cASMETileWindow::OnBitmapInsertBefore(){
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260] = "*.bmp";       // buffer for file name
	char szFileTitle[256];

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Files(*.*)\0*.*\0Bitmap Files(*.bmp)\0*.bmp\0";
	ofn.nFilterIndex = 2;
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = 256;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	int Index;

	// Display the Open dialog box. 
	if (GetOpenFileName(&ofn)){
		Index = BitmapList.SendMessage(LB_GETCURSEL);
		if(Index == LB_ERR){
			Index = 0;
		}
		if(TileWindow.GetTileSet()->InsertBitmap(szFileTitle, Index)){
			BitmapList.SendMessage(LB_INSERTSTRING, Index, (LPARAM)szFileTitle);
			BitmapList.SendMessage(LB_SETCURSEL, Index);
			TileWindow.Invalidate();
		}else{
			MessageBox("Bitmap file could not loaded.", "Error");
		}
	}

}
void cASMETileWindow::OnBitmapInsertAfter(){
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260] = "*.bmp";       // buffer for file name
	char szFileTitle[256];

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Files(*.*)\0*.*\0Bitmap Files(*.bmp)\0*.bmp\0";
	ofn.nFilterIndex = 2;
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = 256;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	int Index;

	// Display the Open dialog box. 
	if (GetOpenFileName(&ofn)){
		Index = BitmapList.SendMessage(LB_GETCURSEL);
		if(Index == LB_ERR){
			Index = 0;
		}else{
			Index ++;
		}
		if(TileWindow.GetTileSet()->InsertBitmap(szFileTitle, Index)){
			BitmapList.SendMessage(LB_ADDSTRING, 0, (LPARAM)szFileTitle);
			BitmapList.SendMessage(LB_SETCURSEL, Index);
			TileWindow.Invalidate();
		}else{
			MessageBox("Bitmap file could not loaded.", "Error");
		}
	}

}

void cASMETileWindow::OnBitmapDelete(){
	int Index;

	Index = BitmapList.SendMessage(LB_GETCURSEL);
	if(Index != LB_ERR){
		TileWindow.GetTileSet()->DeleteBitmap(Index);
		BitmapList.SendMessage(LB_DELETESTRING, Index);
		TileWindow.Invalidate();
	}
}

void cASMETileWindow::OnBitmapMoveUp(){
	cPicture *pPicture1, *pPicture2;
	char szFileTitle[256];
	int Index;


	Index = BitmapList.SendMessage(LB_GETCURSEL);
	if(Index != LB_ERR && Index >= 1){
		pPicture1 = TileWindow.GetTileSet()->GetPictureBook()->GetPicture(Index - 1);
		pPicture2 = TileWindow.GetTileSet()->GetPictureBook()->GetPicture(Index);
		TileWindow.GetTileSet()->GetPictureBook()->Set(Index - 1, pPicture2);
		TileWindow.GetTileSet()->GetPictureBook()->Set(Index, pPicture1);
		TileWindow.GetTileSet()->UpdateTileIndex();

		BitmapList.SendMessage(LB_GETTEXT, Index, (LPARAM)szFileTitle);
		BitmapList.SendMessage(LB_DELETESTRING, Index, (LPARAM)szFileTitle);
		BitmapList.SendMessage(LB_INSERTSTRING, Index - 1, (LPARAM)szFileTitle);

		TileWindow.Invalidate();
	}
}

void cASMETileWindow::OnBitmapMoveDown(){
	cPicture *pPicture1, *pPicture2;
	char szFileTitle[256];
	int Index;


	Index = BitmapList.SendMessage(LB_GETCURSEL);
	if(Index != LB_ERR && Index < TileWindow.GetTileSet()->GetPictureBook()->GetCount() - 1){
		pPicture1 = TileWindow.GetTileSet()->GetPictureBook()->GetPicture(Index);
		pPicture2 = TileWindow.GetTileSet()->GetPictureBook()->GetPicture(Index + 1);
		TileWindow.GetTileSet()->GetPictureBook()->Set(Index, pPicture2);
		TileWindow.GetTileSet()->GetPictureBook()->Set(Index + 1, pPicture1);
		TileWindow.GetTileSet()->UpdateTileIndex();

		BitmapList.SendMessage(LB_GETTEXT, Index + 1, (LPARAM)szFileTitle);
		BitmapList.SendMessage(LB_DELETESTRING, Index + 1, (LPARAM)szFileTitle);
		BitmapList.SendMessage(LB_INSERTSTRING, Index, (LPARAM)szFileTitle);

		TileWindow.Invalidate();
	}
}

void cASMETileWindow::OnTileNew(){
	BitmapList.SendMessage(LB_RESETCONTENT);
	TileWindow.NewTileSet();

}

void cASMETileWindow::OnTileLoad(){
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260] = "*.ts";       // buffer for file name

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Files(*.*)\0*.*\0Tile Set(*.ts)\0*.ts\0";
	ofn.nFilterIndex = 2;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	// Display the Open dialog box. 
	if (GetOpenFileName(&ofn)){
		if(TileWindow.LoadTileSet(szFile)){
			int i;
			// Ʈ  о Ʈ Ʈ Ѵ.
			BitmapList.SendMessage(LB_RESETCONTENT);
			for(i = 0; i < TileWindow.GetTileSet()->GetPictureBook()->GetCount(); i ++){
				BitmapList.SendMessage(LB_ADDSTRING, 0, 
					(LPARAM)TileWindow.GetTileSet()->GetPictureBook()->Get(i)->GetFileName()->Get());
			}
			
			((cASMEAppWindow*)GetParent())->UpdateAllMapWindows();
		}else{
			MessageBox("TileSet file could not loaded.", "Error");
		}

	}
}

void cASMETileWindow::OnTileSave(){
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260] = "*.ts";       // buffer for file name

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Files(*.*)\0*.*\0TileSet Files(*.ts)\0*.ts\0";
	ofn.nFilterIndex = 2;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrDefExt = "map";
	ofn.Flags = OFN_PATHMUSTEXIST;

	// Display the Open dialog box. 
	if (GetSaveFileName(&ofn)){
		if(!TileWindow.SaveTileSet(szFile)){
			MessageBox("TileSet file could not saved.", "Error");
		}
	}

}

void cASMETileWindow::OnViewTileProperty(){
	HMENU hMenu;


	hMenu = GetMenu();
//	hMenu = GetSubMenu(hMenu, 3);

	if(hMenu){
		if(GetMenuState(hMenu, IDM_ViewTileProperty, MF_BYCOMMAND) & MF_CHECKED){
			TileWindow.SetTilePropDrawing(false);
			CheckMenuItem(hMenu, IDM_ViewTileProperty, MF_UNCHECKED);

		}else{
			TileWindow.SetTilePropDrawing(true);
			CheckMenuItem(hMenu, IDM_ViewTileProperty, MF_CHECKED);
		}
	}
}


cTileWindow *cASMETileWindow::GetTileWindow(){
	return &TileWindow;
}
