#ifndef cASMETileWindow_H
#define cASMETileWindow_H

#include "cWindow.h"
#include "cTileSet.h"
#include "cClipper.h"

#include "cTileWindow.h"
#include "cCommonControl.h"

class cASMETileWindow : public cWindow{
protected:
	// ڽ   .
	cTileWindow TileWindow;
	cListControl BitmapList;
		

	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual char *GetClassName(){ return "cASMETileWindow"; }

	// Message Handlers
	bool OnClose(WPARAM wParam, LPARAM lParam);
	bool OnCreate(WPARAM wParam, LPARAM lParam);
	void OnDestroy(WPARAM wParam, LPARAM lParam);
	void OnSize(WPARAM wParam, LPARAM lParam);
	void OnPaint(WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnCommand(WPARAM wParam, LPARAM lParam);

	
	void OnBitmapInsertBefore();
	void OnBitmapInsertAfter();
	void OnBitmapDelete();
	void OnBitmapMoveUp();
	void OnBitmapMoveDown();
	void OnTileNew();
	void OnTileLoad();
	void OnTileSave();
	void OnViewTileProperty();

	void RecalcScrollBars();

	int GetTileIDAtPt(int x, int y);

	void DrawDragRect(cRect Rect);


public:
	cASMETileWindow();
	virtual ~cASMETileWindow();
	static bool RegisterClass();

	cTileWindow *GetTileWindow();

};

#endif
