#include "TOOL.h"
#include "cTilePropDialog.h"

#include "TOOLDebug.h"
#include "Resource.h"

#include "cDisplay.h"

cTilePropDialog::cTilePropDialog(){
	TileID = 0;
	TileHeight = 0;
	TileProp = 0;
	pTilePicture = 0;
}

cTilePropDialog::~cTilePropDialog(){

}

BOOL cTilePropDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	char String[256];

	switch(uMsg){
	case WM_INITDIALOG:
		SetDlgItemInt(IDC_TileID, TileID);
		SetDlgItemInt(IDC_TileHeight, TileHeight);
		SetDlgItemInt(IDC_TileProp, TileProp);
		sprintf(String, "%X", TileProp);
		SetDlgItemText(IDC_TilePropHex, String);
		Clipper.Create(hWnd);
		break;
	case WM_DESTROY:
		Clipper.Destroy();
		break;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDOK:
			TileHeight = GetDlgItemInt(IDC_TileHeight);
			TileProp = GetDlgItemInt(IDC_TileProp);
			EndDialog(LOWORD(wParam));
			return TRUE;

		case IDCANCEL:
			EndDialog(LOWORD(wParam));
			return TRUE;
		case IDC_TileProp:
			if(HIWORD(wParam) == EN_CHANGE){
				TileProp = GetDlgItemInt(IDC_TileProp);
				sprintf(String, "%X", TileProp);
				SetDlgItemText(IDC_TilePropHex, String);
			}
			
			break;
		case IDC_TilePropHex:
			if(HIWORD(wParam) == EN_CHANGE){
				GetDlgItemText(IDC_TilePropHex, String, 256);
				sscanf(String, "%x", &TileProp);
				if(TileProp != GetDlgItemInt(IDC_TileProp)) 
					SetDlgItemInt(IDC_TileProp, TileProp);
			}
			break;

		}
	}
    return FALSE; 
}

void cTilePropDialog::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	cRect ScreenRect;
	
	BeginPaint(&ps);
	EndPaint(&ps);
	
	GetClientRect(ScreenRect);
	ClientToScreen(ScreenRect);

	if(pTilePicture){
		Display.GetFrontPic()->Blt(
			ScreenRect.left + 8, ScreenRect.top + 8, pTilePicture);
	}
}
